@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServerBackupPlans.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property plans
 */
public data class GetServerBackupPlansResult(
    public val filters: List<GetServerBackupPlansFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val plans: List<GetServerBackupPlansPlan>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetServerBackupPlansResult): GetServerBackupPlansResult = GetServerBackupPlansResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetServerBackupPlansFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetServerBackupPlansPlan.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
