@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getSnapshots.
 * @property bucket
 * @property completeTime
 * @property completeTimeChecker
 * @property createTime
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property limit
 * @property outputFile
 * @property query
 * @property snapshots
 * @property sourceType
 * @property status
 * @property vaultId
 */
public data class GetSnapshotsResult(
    public val bucket: String? = null,
    public val completeTime: String? = null,
    public val completeTimeChecker: String? = null,
    public val createTime: String? = null,
    public val fileSystemId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val limit: Int? = null,
    public val outputFile: String? = null,
    public val query: String? = null,
    public val snapshots: List<GetSnapshotsSnapshot>,
    public val sourceType: String,
    public val status: String? = null,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetSnapshotsResult): GetSnapshotsResult = GetSnapshotsResult(
            bucket = javaType.bucket().map({ args0 -> args0 }).orElse(null),
            completeTime = javaType.completeTime().map({ args0 -> args0 }).orElse(null),
            completeTimeChecker = javaType.completeTimeChecker().map({ args0 -> args0 }).orElse(null),
            createTime = javaType.createTime().map({ args0 -> args0 }).orElse(null),
            fileSystemId = javaType.fileSystemId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            limit = javaType.limit().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            query = javaType.query().map({ args0 -> args0 }).orElse(null),
            snapshots = javaType.snapshots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetSnapshotsSnapshot.Companion.toKotlin(args0)
                })
            }),
            sourceType = javaType.sourceType(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vaultId = javaType.vaultId(),
        )
    }
}
