@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actualBytes The actual data volume of the snapshot. Unit byte.
 * @property actualItems The actual number of items in the snapshot. (Currently only file backup is available).
 * @property backupType Backup type. Possible values: `COMPLETE` (full backup).
 * @property bucket The name of OSS bucket.
 * @property bytesDone The incremental amount of backup data. Unit byte.
 * @property bytesTotal The total amount of data sources. Unit byte.
 * @property clientId The ID of ECS backup client.
 * @property completeTime The time when the snapshot completed. UNIX time in seconds.
 * @property createTime File System Creation Time of Nas. Unix Time Seconds.
 * @property createdTime Snapshot creation time. UNIX time in seconds.
 * @property errorFile
 * @property fileSystemId The ID of NAS File system.
 * @property id The ID of the Snapshot.
 * @property instanceId The ID of ECS instance.
 * @property itemsDone The number of backup items. (Currently only file backup is available).
 * @property itemsTotal The total number of data source items. (Currently only file backup is available).
 * @property jobId The job ID of backup task.
 * @property parentSnapshotHash The hashcode of parent backup snapshot.
 * @property path Backup Path.
 * @property prefix Backup file prefix.
 * @property retention The number of days to keep.
 * @property snapshotHash The hashcode of Snapshot.
 * @property snapshotId The ID of the Snapshot.
 * @property sourceType Data source type, optional values: `ECS_FILE`, `OSS`, `NAS`.
 * @property startTime The start time of the snapshot. UNIX time in seconds.
 * @property status The status of snapshot execution. Possible values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`.
 * @property updatedTime The update time of snapshot. UNIX time in seconds.
 */
public data class GetSnapshotsSnapshot(
    public val actualBytes: String,
    public val actualItems: String,
    public val backupType: String,
    public val bucket: String,
    public val bytesDone: String,
    public val bytesTotal: String,
    public val clientId: String,
    public val completeTime: String,
    public val createTime: String,
    public val createdTime: String,
    public val errorFile: String,
    public val fileSystemId: String,
    public val id: String,
    public val instanceId: String,
    public val itemsDone: String,
    public val itemsTotal: String,
    public val jobId: String,
    public val parentSnapshotHash: String,
    public val path: String,
    public val prefix: String,
    public val retention: String,
    public val snapshotHash: String,
    public val snapshotId: String,
    public val sourceType: String,
    public val startTime: String,
    public val status: String,
    public val updatedTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetSnapshotsSnapshot): GetSnapshotsSnapshot = GetSnapshotsSnapshot(
            actualBytes = javaType.actualBytes(),
            actualItems = javaType.actualItems(),
            backupType = javaType.backupType(),
            bucket = javaType.bucket(),
            bytesDone = javaType.bytesDone(),
            bytesTotal = javaType.bytesTotal(),
            clientId = javaType.clientId(),
            completeTime = javaType.completeTime(),
            createTime = javaType.createTime(),
            createdTime = javaType.createdTime(),
            errorFile = javaType.errorFile(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            itemsDone = javaType.itemsDone(),
            itemsTotal = javaType.itemsTotal(),
            jobId = javaType.jobId(),
            parentSnapshotHash = javaType.parentSnapshotHash(),
            path = javaType.path(),
            prefix = javaType.prefix(),
            retention = javaType.retention(),
            snapshotHash = javaType.snapshotHash(),
            snapshotId = javaType.snapshotId(),
            sourceType = javaType.sourceType(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            updatedTime = javaType.updatedTime(),
        )
    }
}
