@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketName The name of the OSS bucket of the Vault.
 * @property bytesDone The amount of backup data. The unit is Byte.
 * @property createdTime The creation time of the Vault. UNIX time in seconds.
 * @property dedup Whether to enable the deduplication function for the database backup Vault.
 * @property description The description of the vault.
 * @property id The ID of vault.
 * @property indexAvailable Index available.
 * @property indexLevel Index level.
 * @property indexUpdateTime Index update time.
 * @property latestReplicationTime The time of the last remote backup synchronization.
 * @property paymentType Billing model, possible values:
 * * `FREE` is not billed
 * * `V1` common vault billing model, including back-end storage capacity, client licenses and other billing items
 * * `V2` new version of metering mode
 * * `AEGIS` Billing method for cloud security use
 * * `UNI_BACKUP` the backup of deduplication database
 * * `ARCHIVE` archive library.
 * @property replication Whether it is a remote backup warehouse. It's a boolean value.
 * @property replicationSourceRegionId The region ID to which the remote backup Vault belongs.
 * @property replicationSourceVaultId The source vault ID of the remote backup Vault.
 * @property retention Warehouse-level data retention days, only valid for archive libraries.
 * @property searchEnabled Whether to enable the backup search function.
 * @property sourceTypes
 * @property status The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
 * @property storageSize Backup vault storage usage. The unit is Byte.
 * @property updatedTime The update time of the Vault. UNIX time in seconds.
 * @property vaultId The ID of vault, same as `id`.
 * @property vaultName The name of vault.
 * @property vaultStatusMessage Error status information of Vault. Only valid for remote backup warehouses. Only the remote backup warehouse is valid.
 * @property vaultStorageClass The storage class of vault. Valid values: `STANDARD`.
 * @property vaultType The type of Vault. Valid values: `STANDARD`,`OTS_BACKUP`.
 */
public data class GetVaultsVault(
    public val bucketName: String,
    public val bytesDone: String,
    public val createdTime: String,
    public val dedup: Boolean,
    public val description: String,
    public val id: String,
    public val indexAvailable: Boolean,
    public val indexLevel: String,
    public val indexUpdateTime: String,
    public val latestReplicationTime: String,
    public val paymentType: String,
    public val replication: Boolean,
    public val replicationSourceRegionId: String,
    public val replicationSourceVaultId: String,
    public val retention: String,
    public val searchEnabled: Boolean,
    public val sourceTypes: List<String>,
    public val status: String,
    public val storageSize: String,
    public val updatedTime: String,
    public val vaultId: String,
    public val vaultName: String,
    public val vaultStatusMessage: String,
    public val vaultStorageClass: String,
    public val vaultType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetVaultsVault): GetVaultsVault =
            GetVaultsVault(
                bucketName = javaType.bucketName(),
                bytesDone = javaType.bytesDone(),
                createdTime = javaType.createdTime(),
                dedup = javaType.dedup(),
                description = javaType.description(),
                id = javaType.id(),
                indexAvailable = javaType.indexAvailable(),
                indexLevel = javaType.indexLevel(),
                indexUpdateTime = javaType.indexUpdateTime(),
                latestReplicationTime = javaType.latestReplicationTime(),
                paymentType = javaType.paymentType(),
                replication = javaType.replication(),
                replicationSourceRegionId = javaType.replicationSourceRegionId(),
                replicationSourceVaultId = javaType.replicationSourceVaultId(),
                retention = javaType.retention(),
                searchEnabled = javaType.searchEnabled(),
                sourceTypes = javaType.sourceTypes().map({ args0 -> args0 }),
                status = javaType.status(),
                storageSize = javaType.storageSize(),
                updatedTime = javaType.updatedTime(),
                vaultId = javaType.vaultId(),
                vaultName = javaType.vaultName(),
                vaultStatusMessage = javaType.vaultStatusMessage(),
                vaultStorageClass = javaType.vaultStorageClass(),
                vaultType = javaType.vaultType(),
            )
    }
}
