@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property disabled Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
 * @property retention Backup retention days, the minimum is 1.
 * @property ruleName The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * - `startTime` Backup start time, UNIX time seconds.
 */
public data class OtsBackupPlanRule(
    public val backupType: String? = null,
    public val disabled: Boolean? = null,
    public val retention: String? = null,
    public val ruleName: String? = null,
    public val schedule: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.OtsBackupPlanRule): OtsBackupPlanRule = OtsBackupPlanRule(
            backupType = javaType.backupType().map({ args0 -> args0 }).orElse(null),
            disabled = javaType.disabled().map({ args0 -> args0 }).orElse(null),
            retention = javaType.retention().map({ args0 -> args0 }).orElse(null),
            ruleName = javaType.ruleName().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().map({ args0 -> args0 }).orElse(null),
        )
    }
}
