@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property destinationKmsKeyId Custom KMS key ID of encrypted copy.
 * @property diskIdLists The list of backup disks. If it is empty, all disks are backed up.
 * @property excludeDiskIdLists List of cloud disk IDs that are not backed up.
 */
public data class PolicyBindingAdvancedOptionsUdmDetail(
    public val destinationKmsKeyId: String? = null,
    public val diskIdLists: List<String>? = null,
    public val excludeDiskIdLists: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.PolicyBindingAdvancedOptionsUdmDetail): PolicyBindingAdvancedOptionsUdmDetail = PolicyBindingAdvancedOptionsUdmDetail(
            destinationKmsKeyId = javaType.destinationKmsKeyId().map({ args0 -> args0 }).orElse(null),
            diskIdLists = javaType.diskIdLists().map({ args0 -> args0 }),
            excludeDiskIdLists = javaType.excludeDiskIdLists().map({ args0 -> args0 }),
        )
    }
}
