@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property archiveDays This parameter is required only when the value of **RuleType** is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
 * @property backupType This parameter is required only when the **RuleType** value is **BACKUP. Backup Type.
 * @property keepLatestSnapshots This parameter is required only when **RuleType** is set to **BACKUP**.
 * @property replicationRegionId Only when the **RuleType** value is.
 * @property retention Retention time, in days.
 * @property retentionRules This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
 * @property ruleId Rule ID.
 * @property ruleType Rule Type.
 * @property schedule This parameter is required only if you set the **RuleType** parameter to **BACKUP**. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
 * @property vaultId Vault ID.
 */
public data class PolicyRule(
    public val archiveDays: Int? = null,
    public val backupType: String? = null,
    public val keepLatestSnapshots: Int? = null,
    public val replicationRegionId: String? = null,
    public val retention: Int? = null,
    public val retentionRules: List<PolicyRuleRetentionRule>? = null,
    public val ruleId: String? = null,
    public val ruleType: String,
    public val schedule: String? = null,
    public val vaultId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.PolicyRule): PolicyRule =
            PolicyRule(
                archiveDays = javaType.archiveDays().map({ args0 -> args0 }).orElse(null),
                backupType = javaType.backupType().map({ args0 -> args0 }).orElse(null),
                keepLatestSnapshots = javaType.keepLatestSnapshots().map({ args0 -> args0 }).orElse(null),
                replicationRegionId = javaType.replicationRegionId().map({ args0 -> args0 }).orElse(null),
                retention = javaType.retention().map({ args0 -> args0 }).orElse(null),
                retentionRules = javaType.retentionRules().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.alicloud.hbr.kotlin.outputs.PolicyRuleRetentionRule.Companion.toKotlin(args0)
                    })
                }),
                ruleId = javaType.ruleId().map({ args0 -> args0 }).orElse(null),
                ruleType = javaType.ruleType(),
                schedule = javaType.schedule().map({ args0 -> args0 }).orElse(null),
                vaultId = javaType.vaultId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
