@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property advancedRetentionType Valid values: **annually**, **MONTHLY**, and **WEEKLY**:- **annually**: the first backup of each year. - **MONTHLY**: The first backup of the month. - **WEEKLY**: The first backup of the week.
 * @property retention Retention time, in days.
 */
public data class PolicyRuleRetentionRule(
    public val advancedRetentionType: String? = null,
    public val retention: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.PolicyRuleRetentionRule): PolicyRuleRetentionRule = PolicyRuleRetentionRule(
            advancedRetentionType = javaType.advancedRetentionType().map({ args0 -> args0 }).orElse(null),
            retention = javaType.retention().map({ args0 -> args0 }).orElse(null),
        )
    }
}
