@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hologram.kotlin

import com.pulumi.alicloud.hologram.InstanceArgs.builder
import com.pulumi.alicloud.hologram.kotlin.inputs.InstanceEndpointArgs
import com.pulumi.alicloud.hologram.kotlin.inputs.InstanceEndpointArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * Hologram Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hologram/instance:Instance example <id>
 * ```
 * @property autoPay Whether to pay automatically. The default value is true. Value:
 * - true: automatic payment
 * - false: only generate orders, not pay
 * > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
 * @property coldStorageSize Instance low-frequency storage space. Unit: GB.
 * > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
 * @property cpu Instance specifications. Value:
 * - 8 cores 32 GB (number of compute nodes: 1)
 * - 16 cores 64 GB (number of compute nodes: 1)
 * - 32 core 128 GB (number of compute nodes: 2)
 * - 64 core 256 GB (number of compute nodes: 4)
 * - 96 core 384 GB (number of computing nodes: 6)
 * - 128 core 512 GB (number of compute nodes: 8)
 * > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
 * @property duration The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
 * @property endpoints List of domain names. See `endpoints` below.
 * @property gatewayCount Number of gateway nodes.
 * @property initialDatabases Initialize the database and split multiple database names ",".
 * @property instanceName The name of the resource.
 * @property instanceType The instance type. Value:
 * - Standard: Universal.
 * - Follower: Read-only slave instance.
 * - Warehouse: calculation group type.
 * - Shared: Shared.
 * @property leaderInstanceId The ID of the primary instance.
 * @property paymentType The payment type of the resource.
 * @property pricingCycle Billing cycle. Value:
 * - Month: monthly billing
 * - Hour: hourly billing
 * > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
 * @property resourceGroupId The ID of the resource group.
 * @property scaleType Change matching type. Value:
 * - UPGRADE: UPGRADE
 * - DOWNGRADE: Downgrading
 * > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
 * @property status The status of the resource.
 * @property storageSize The standard storage space of the instance. Unit: GB.
 * > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
 * @property tags Instance tag.
 * @property zoneId The zone Id. Refer to "Instructions for Use".
 */
public data class InstanceArgs(
    public val autoPay: Output<Boolean>? = null,
    public val coldStorageSize: Output<Int>? = null,
    public val cpu: Output<Int>? = null,
    public val duration: Output<Int>? = null,
    public val endpoints: Output<List<InstanceEndpointArgs>>? = null,
    public val gatewayCount: Output<Int>? = null,
    public val initialDatabases: Output<String>? = null,
    public val instanceName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val leaderInstanceId: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val pricingCycle: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scaleType: Output<String>? = null,
    public val status: Output<String>? = null,
    public val storageSize: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hologram.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.hologram.InstanceArgs =
        com.pulumi.alicloud.hologram.InstanceArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .coldStorageSize(coldStorageSize?.applyValue({ args0 -> args0 }))
            .cpu(cpu?.applyValue({ args0 -> args0 }))
            .duration(duration?.applyValue({ args0 -> args0 }))
            .endpoints(
                endpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .gatewayCount(gatewayCount?.applyValue({ args0 -> args0 }))
            .initialDatabases(initialDatabases?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .leaderInstanceId(leaderInstanceId?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .pricingCycle(pricingCycle?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scaleType(scaleType?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .storageSize(storageSize?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var coldStorageSize: Output<Int>? = null

    private var cpu: Output<Int>? = null

    private var duration: Output<Int>? = null

    private var endpoints: Output<List<InstanceEndpointArgs>>? = null

    private var gatewayCount: Output<Int>? = null

    private var initialDatabases: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var leaderInstanceId: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var pricingCycle: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scaleType: Output<String>? = null

    private var status: Output<String>? = null

    private var storageSize: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Whether to pay automatically. The default value is true. Value:
     * - true: automatic payment
     * - false: only generate orders, not pay
     * > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
     */
    @JvmName("evyrjqgglxmbnaja")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Instance low-frequency storage space. Unit: GB.
     * > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
     */
    @JvmName("pkeagfqpebhwlvtv")
    public suspend fun coldStorageSize(`value`: Output<Int>) {
        this.coldStorageSize = value
    }

    /**
     * @param value Instance specifications. Value:
     * - 8 cores 32 GB (number of compute nodes: 1)
     * - 16 cores 64 GB (number of compute nodes: 1)
     * - 32 core 128 GB (number of compute nodes: 2)
     * - 64 core 256 GB (number of compute nodes: 4)
     * - 96 core 384 GB (number of computing nodes: 6)
     * - 128 core 512 GB (number of compute nodes: 8)
     * > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
     */
    @JvmName("nafvadkoecfcyash")
    public suspend fun cpu(`value`: Output<Int>) {
        this.cpu = value
    }

    /**
     * @param value The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
     */
    @JvmName("pqvytucccgmmsigr")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value List of domain names. See `endpoints` below.
     */
    @JvmName("dpjcgpcuuhfquave")
    public suspend fun endpoints(`value`: Output<List<InstanceEndpointArgs>>) {
        this.endpoints = value
    }

    @JvmName("xtdotbegsrgsqrti")
    public suspend fun endpoints(vararg values: Output<InstanceEndpointArgs>) {
        this.endpoints = Output.all(values.asList())
    }

    /**
     * @param values List of domain names. See `endpoints` below.
     */
    @JvmName("avhbvvmbwkmbwfar")
    public suspend fun endpoints(values: List<Output<InstanceEndpointArgs>>) {
        this.endpoints = Output.all(values)
    }

    /**
     * @param value Number of gateway nodes.
     */
    @JvmName("kxsbixfmandbtsme")
    public suspend fun gatewayCount(`value`: Output<Int>) {
        this.gatewayCount = value
    }

    /**
     * @param value Initialize the database and split multiple database names ",".
     */
    @JvmName("qomixorfdiyffvgy")
    public suspend fun initialDatabases(`value`: Output<String>) {
        this.initialDatabases = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("lmiprrndekwlgnyj")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The instance type. Value:
     * - Standard: Universal.
     * - Follower: Read-only slave instance.
     * - Warehouse: calculation group type.
     * - Shared: Shared.
     */
    @JvmName("anmsodlimnjjfvhg")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The ID of the primary instance.
     */
    @JvmName("mgyekntqcophxfif")
    public suspend fun leaderInstanceId(`value`: Output<String>) {
        this.leaderInstanceId = value
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("selsemvntmtmehsm")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Billing cycle. Value:
     * - Month: monthly billing
     * - Hour: hourly billing
     * > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
     */
    @JvmName("hrxqeasduhjpdbbf")
    public suspend fun pricingCycle(`value`: Output<String>) {
        this.pricingCycle = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("dxafjxqpvpdnmcnn")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Change matching type. Value:
     * - UPGRADE: UPGRADE
     * - DOWNGRADE: Downgrading
     * > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
     */
    @JvmName("jcovetxqljvuqsfb")
    public suspend fun scaleType(`value`: Output<String>) {
        this.scaleType = value
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("qbkrijwqjrbnbtdr")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The standard storage space of the instance. Unit: GB.
     * > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
     */
    @JvmName("nxoooiypoityitqw")
    public suspend fun storageSize(`value`: Output<Int>) {
        this.storageSize = value
    }

    /**
     * @param value Instance tag.
     */
    @JvmName("qabjbchrgwpeomew")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The zone Id. Refer to "Instructions for Use".
     */
    @JvmName("wpervbgpfojnrkmw")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Whether to pay automatically. The default value is true. Value:
     * - true: automatic payment
     * - false: only generate orders, not pay
     * > **NOTE:**  The default value is true. If the balance of your payment method is insufficient, you can set the parameter AutoPay to false, and an unpaid order will be generated. You can log in to the user Center to pay by yourself.
     */
    @JvmName("hbueqqxtmonneyui")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Instance low-frequency storage space. Unit: GB.
     * > **NOTE:**  PayAsYouGo (PostPaid) instances ignore this parameter.
     */
    @JvmName("mlqhxqyophbyyetm")
    public suspend fun coldStorageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coldStorageSize = mapped
    }

    /**
     * @param value Instance specifications. Value:
     * - 8 cores 32 GB (number of compute nodes: 1)
     * - 16 cores 64 GB (number of compute nodes: 1)
     * - 32 core 128 GB (number of compute nodes: 2)
     * - 64 core 256 GB (number of compute nodes: 4)
     * - 96 core 384 GB (number of computing nodes: 6)
     * - 128 core 512 GB (number of compute nodes: 8)
     * > **NOTE:** Just fill in the audit number. Please submit a work order application for purchasing 1024 or above specifications. Shared instance types do not need to specify specifications. The specification of - 8 core 32GB (number of computing nodes: 1) is only for experience use and cannot be used for production.
     */
    @JvmName("xvdtwwscwbvpqrqb")
    public suspend fun cpu(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpu = mapped
    }

    /**
     * @param value The buying cycle. Buy for 2 months. If the Payment type is PayAsYouGo (PostPaid), you do not need to specify it.
     */
    @JvmName("cpovocniawpvvrtw")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value List of domain names. See `endpoints` below.
     */
    @JvmName("uxlfidewwheglqup")
    public suspend fun endpoints(`value`: List<InstanceEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param argument List of domain names. See `endpoints` below.
     */
    @JvmName("strdxfssalttbged")
    public suspend fun endpoints(argument: List<suspend InstanceEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument List of domain names. See `endpoints` below.
     */
    @JvmName("bltidwkxesacsxdd")
    public suspend fun endpoints(vararg argument: suspend InstanceEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param argument List of domain names. See `endpoints` below.
     */
    @JvmName("mdshjpcwjhegxoic")
    public suspend fun endpoints(argument: suspend InstanceEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.endpoints = mapped
    }

    /**
     * @param values List of domain names. See `endpoints` below.
     */
    @JvmName("hxndumeevnobgucp")
    public suspend fun endpoints(vararg values: InstanceEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoints = mapped
    }

    /**
     * @param value Number of gateway nodes.
     */
    @JvmName("uvmlsqajdjybipxo")
    public suspend fun gatewayCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayCount = mapped
    }

    /**
     * @param value Initialize the database and split multiple database names ",".
     */
    @JvmName("cgyjlrnsoucxpyvk")
    public suspend fun initialDatabases(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDatabases = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("wgaenbxomugtuvwb")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The instance type. Value:
     * - Standard: Universal.
     * - Follower: Read-only slave instance.
     * - Warehouse: calculation group type.
     * - Shared: Shared.
     */
    @JvmName("tdjiikpwvnlxnkle")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The ID of the primary instance.
     */
    @JvmName("jlskhpkmsvwdocmo")
    public suspend fun leaderInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.leaderInstanceId = mapped
    }

    /**
     * @param value The payment type of the resource.
     */
    @JvmName("uyharuwnwjhrsqsn")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Billing cycle. Value:
     * - Month: monthly billing
     * - Hour: hourly billing
     * > **NOTE:**  Subscription instances (PrePaid) only supports Month. PayAsYouGo instances (PostPaid) only supports Hour. The Shared type is automatically set to Hour without specifying it.
     */
    @JvmName("ougcjchurpmalrfe")
    public suspend fun pricingCycle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingCycle = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("xhxscblqqgskthtg")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Change matching type. Value:
     * - UPGRADE: UPGRADE
     * - DOWNGRADE: Downgrading
     * > **NOTE:** The upgrade specification cannot be less than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is larger than the original specification. The downgrading specification cannot be greater than the original specification. A blank field indicates that the original specification remains unchanged. On this basis, at least one specification is smaller than the original specification.
     */
    @JvmName("oowbiytifcyxepfs")
    public suspend fun scaleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleType = mapped
    }

    /**
     * @param value The status of the resource.
     */
    @JvmName("svibqsviolmwyvay")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The standard storage space of the instance. Unit: GB.
     * > **NOTE:**  PayAsYouGo instances (PostPaid) ignore this parameter.
     */
    @JvmName("klfjxqconvedxclj")
    public suspend fun storageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSize = mapped
    }

    /**
     * @param value Instance tag.
     */
    @JvmName("dmydpastsjaemssg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Instance tag.
     */
    @JvmName("jwjkvevklglvqgmp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The zone Id. Refer to "Instructions for Use".
     */
    @JvmName("trtqytgeevlftubm")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        autoPay = autoPay,
        coldStorageSize = coldStorageSize,
        cpu = cpu,
        duration = duration,
        endpoints = endpoints,
        gatewayCount = gatewayCount,
        initialDatabases = initialDatabases,
        instanceName = instanceName,
        instanceType = instanceType,
        leaderInstanceId = leaderInstanceId,
        paymentType = paymentType,
        pricingCycle = pricingCycle,
        resourceGroupId = resourceGroupId,
        scaleType = scaleType,
        status = status,
        storageSize = storageSize,
        tags = tags,
        zoneId = zoneId,
    )
}
