@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hologram.kotlin.inputs

import com.pulumi.alicloud.hologram.inputs.InstanceEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alternativeEndpoints Some old instances have both AnyTunnel and SingleTunnel enabled. When switching from AnyTunnel to SingleTunnel, the endpoints of both are retained. Therefore, one more field is required to store the Endpoint.
 * @property enabled Whether to turn on the network.
 * @property endpoint Domain name.
 * @property type The network type.
 * @property vpcId VPC primary key.
 * @property vpcInstanceId The vpc instance ID.
 * @property vswitchId The ID of the virtual switch.
 */
public data class InstanceEndpointArgs(
    public val alternativeEndpoints: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val endpoint: Output<String>? = null,
    public val type: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vpcInstanceId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hologram.inputs.InstanceEndpointArgs> {
    override fun toJava(): com.pulumi.alicloud.hologram.inputs.InstanceEndpointArgs =
        com.pulumi.alicloud.hologram.inputs.InstanceEndpointArgs.builder()
            .alternativeEndpoints(alternativeEndpoints?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcInstanceId(vpcInstanceId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceEndpointArgs].
 */
@PulumiTagMarker
public class InstanceEndpointArgsBuilder internal constructor() {
    private var alternativeEndpoints: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var endpoint: Output<String>? = null

    private var type: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vpcInstanceId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Some old instances have both AnyTunnel and SingleTunnel enabled. When switching from AnyTunnel to SingleTunnel, the endpoints of both are retained. Therefore, one more field is required to store the Endpoint.
     */
    @JvmName("pmbkrqvoduwelkhy")
    public suspend fun alternativeEndpoints(`value`: Output<String>) {
        this.alternativeEndpoints = value
    }

    /**
     * @param value Whether to turn on the network.
     */
    @JvmName("bdyhexovnhqopmma")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Domain name.
     */
    @JvmName("aemajqelptlkgmap")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The network type.
     */
    @JvmName("qwyqmcgbffhnswyt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value VPC primary key.
     */
    @JvmName("inusxkgghtsabkck")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The vpc instance ID.
     */
    @JvmName("sxesjprsdahtqqlg")
    public suspend fun vpcInstanceId(`value`: Output<String>) {
        this.vpcInstanceId = value
    }

    /**
     * @param value The ID of the virtual switch.
     */
    @JvmName("osstgmrkycaxxnrq")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Some old instances have both AnyTunnel and SingleTunnel enabled. When switching from AnyTunnel to SingleTunnel, the endpoints of both are retained. Therefore, one more field is required to store the Endpoint.
     */
    @JvmName("pbxmyfikcjhqsdcg")
    public suspend fun alternativeEndpoints(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternativeEndpoints = mapped
    }

    /**
     * @param value Whether to turn on the network.
     */
    @JvmName("vkohqfimenxobdix")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Domain name.
     */
    @JvmName("ktrclojejphtrcos")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The network type.
     */
    @JvmName("cnxdwpnjgdrkctpv")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value VPC primary key.
     */
    @JvmName("ccnclxovhgeybpcc")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The vpc instance ID.
     */
    @JvmName("pgixxxfsrmahnopm")
    public suspend fun vpcInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcInstanceId = mapped
    }

    /**
     * @param value The ID of the virtual switch.
     */
    @JvmName("uhgjnmkmwdatyilr")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): InstanceEndpointArgs = InstanceEndpointArgs(
        alternativeEndpoints = alternativeEndpoints,
        enabled = enabled,
        endpoint = endpoint,
        type = type,
        vpcId = vpcId,
        vpcInstanceId = vpcInstanceId,
        vswitchId = vswitchId,
    )
}
