@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hologram.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alternativeEndpoints Some old instances have both AnyTunnel and SingleTunnel enabled. When switching from AnyTunnel to SingleTunnel, the endpoints of both are retained. Therefore, one more field is required to store the Endpoint.
 * @property enabled Whether to turn on the network.
 * @property endpoint Domain name.
 * @property type The network type.
 * @property vpcId VPC primary key.
 * @property vpcInstanceId The vpc instance ID.
 * @property vswitchId The ID of the virtual switch.
 */
public data class InstanceEndpoint(
    public val alternativeEndpoints: String? = null,
    public val enabled: Boolean? = null,
    public val endpoint: String? = null,
    public val type: String? = null,
    public val vpcId: String? = null,
    public val vpcInstanceId: String? = null,
    public val vswitchId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hologram.outputs.InstanceEndpoint): InstanceEndpoint = InstanceEndpoint(
            alternativeEndpoints = javaType.alternativeEndpoints().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            endpoint = javaType.endpoint().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            vpcId = javaType.vpcId().map({ args0 -> args0 }).orElse(null),
            vpcInstanceId = javaType.vpcInstanceId().map({ args0 -> args0 }).orElse(null),
            vswitchId = javaType.vswitchId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
