@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imm.kotlin

import com.pulumi.alicloud.imm.ImmFunctions.getProjectsPlain
import com.pulumi.alicloud.imm.kotlin.inputs.GetProjectsPlainArgs
import com.pulumi.alicloud.imm.kotlin.inputs.GetProjectsPlainArgsBuilder
import com.pulumi.alicloud.imm.kotlin.outputs.GetProjectsResult
import com.pulumi.alicloud.imm.kotlin.outputs.GetProjectsResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object ImmFunctions {
    /**
     * This data source provides the Intelligent Media Management Projects of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.imm.getProjects({
     *     ids: ["example_id"],
     * });
     * export const immProjectId1 = ids.then(ids => ids.projects?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.imm.get_projects(ids=["example_id"])
     * pulumi.export("immProjectId1", ids.projects[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Imm.GetProjects.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "example_id",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["immProjectId1"] = ids&#46;Apply(getProjectsResult => getProjectsResult&#46;Projects[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/imm"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := imm.GetProjects(ctx, &imm.GetProjectsArgs{
     * 			Ids: []string{
     * 				"example_id",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("immProjectId1", ids.Projects[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.imm.ImmFunctions;
     * import com.pulumi.alicloud.imm.inputs.GetProjectsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ImmFunctions.getProjects(GetProjectsArgs.builder()
     *             .ids("example_id")
     *             .build());
     *         ctx.export("immProjectId1", ids.applyValue(getProjectsResult -> getProjectsResult.projects()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:imm:getProjects
     *       Arguments:
     *         ids:
     *           - example_id
     * outputs:
     *   immProjectId1: ${ids.projects[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjects.
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(argument: GetProjectsPlainArgs): GetProjectsResult =
        toKotlin(getProjectsPlain(argument.toJava()).await())

    /**
     * @see [getProjects].
     * @param ids A list of Project IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(ids: List<String>? = null, outputFile: String? = null): GetProjectsResult {
        val argument = GetProjectsPlainArgs(
            ids = ids,
            outputFile = outputFile,
        )
        return toKotlin(getProjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjects].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;imm&#46;kotlin&#46;inputs&#46;GetProjectsPlainArgs].
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(argument: suspend GetProjectsPlainArgsBuilder.() -> Unit): GetProjectsResult {
        val builder = GetProjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getProjectsPlain(builtArgument.toJava()).await())
    }
}
