@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imm.kotlin.inputs

import com.pulumi.alicloud.imm.inputs.GetProjectsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProjects.
 * @property ids A list of Project IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetProjectsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.imm.inputs.GetProjectsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.imm.inputs.GetProjectsPlainArgs =
        com.pulumi.alicloud.imm.inputs.GetProjectsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectsPlainArgs].
 */
@PulumiTagMarker
public class GetProjectsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Project IDs.
     */
    @JvmName("sfgxwphwksfkqywi")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Project IDs.
     */
    @JvmName("gffeeekhavohrlpj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("emttqjkhnkuddrna")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetProjectsPlainArgs = GetProjectsPlainArgs(
        ids = ids,
        outputFile = outputFile,
    )
}
