@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imm.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property billingType The billing type. **Note:** This parameter is deprecated from 2021-04-01.
 * @property computeUnit The maximum number of requests that can be processed per second. **Note:** This parameter is deprecated from 2021-04-01.
 * @property createTime The creation time of project.
 * @property endpoint The service address of project.
 * @property id The ID of project.
 * @property modifyTime The modification time of project.
 * @property project The name of project.
 * @property serviceRole The service role authorized to the Intelligent Media Management service to access other cloud resources.
 * @property type The type of project.
 */
public data class GetProjectsProject(
    public val billingType: String,
    public val computeUnit: Int,
    public val createTime: String,
    public val endpoint: String,
    public val id: String,
    public val modifyTime: String,
    public val project: String,
    public val serviceRole: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.imm.outputs.GetProjectsProject): GetProjectsProject = GetProjectsProject(
            billingType = javaType.billingType(),
            computeUnit = javaType.computeUnit(),
            createTime = javaType.createTime(),
            endpoint = javaType.endpoint(),
            id = javaType.id(),
            modifyTime = javaType.modifyTime(),
            project = javaType.project(),
            serviceRole = javaType.serviceRole(),
            type = javaType.type(),
        )
    }
}
