@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProjects.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property projects
 */
public data class GetProjectsResult(
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val projects: List<GetProjectsProject>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.imm.outputs.GetProjectsResult): GetProjectsResult = GetProjectsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            projects = javaType.projects().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.imm.kotlin.outputs.GetProjectsProject.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
