@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin

import com.pulumi.alicloud.imp.kotlin.outputs.AppTemplateConfigList
import com.pulumi.alicloud.imp.kotlin.outputs.AppTemplateConfigList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AppTemplate].
 */
@PulumiTagMarker
public class AppTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AppTemplateArgs = AppTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AppTemplateArgsBuilder.() -> Unit) {
        val builder = AppTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AppTemplate {
        val builtJavaResource = com.pulumi.alicloud.imp.AppTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AppTemplate(builtJavaResource)
    }
}

/**
 * Provides a Apsara Agile Live (IMP) App Template resource.
 * For information about Apsara Agile Live (IMP) App Template and how to use it, see [What is App Template](https://help.aliyun.com/document_detail/270121.html).
 * > **NOTE:** Available in v1.137.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.imp.AppTemplate("example", {
 *     appTemplateName: "example_value",
 *     componentLists: [
 *         "component.live",
 *         "component.liveRecord",
 *     ],
 *     integrationMode: "paasSDK",
 *     scene: "business",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.imp.AppTemplate("example",
 *     app_template_name="example_value",
 *     component_lists=[
 *         "component.live",
 *         "component.liveRecord",
 *     ],
 *     integration_mode="paasSDK",
 *     scene="business")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Imp.AppTemplate("example", new()
 *     {
 *         AppTemplateName = "example_value",
 *         ComponentLists = new[]
 *         {
 *             "component.live",
 *             "component.liveRecord",
 *         },
 *         IntegrationMode = "paasSDK",
 *         Scene = "business",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/imp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imp.NewAppTemplate(ctx, "example", &imp.AppTemplateArgs{
 * 			AppTemplateName: pulumi.String("example_value"),
 * 			ComponentLists: pulumi.StringArray{
 * 				pulumi.String("component.live"),
 * 				pulumi.String("component.liveRecord"),
 * 			},
 * 			IntegrationMode: pulumi.String("paasSDK"),
 * 			Scene:           pulumi.String("business"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.imp.AppTemplate;
 * import com.pulumi.alicloud.imp.AppTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppTemplate("example", AppTemplateArgs.builder()
 *             .appTemplateName("example_value")
 *             .componentLists(
 *                 "component.live",
 *                 "component.liveRecord")
 *             .integrationMode("paasSDK")
 *             .scene("business")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:imp:AppTemplate
 *     properties:
 *       appTemplateName: example_value
 *       componentLists:
 *         - component.live
 *         - component.liveRecord
 *       integrationMode: paasSDK
 *       scene: business
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Apsara Agile Live (IMP) App Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:imp/appTemplate:AppTemplate example <id>
 * ```
 */
public class AppTemplate internal constructor(
    override val javaResource: com.pulumi.alicloud.imp.AppTemplate,
) : KotlinCustomResource(javaResource, AppTemplateMapper) {
    /**
     * The name of the resource.
     */
    public val appTemplateName: Output<String>
        get() = javaResource.appTemplateName().applyValue({ args0 -> args0 })

    /**
     * List of components. Its element valid values: ["component&#46;live","component&#46;liveRecord","component&#46;liveBeauty","component&#46;rtc","component&#46;rtcRecord","component&#46;im","component&#46;whiteboard","component&#46;liveSecurity","component&#46;chatSecurity"].
     */
    public val componentLists: Output<List<String>>
        get() = javaResource.componentLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    public val configLists: Output<List<AppTemplateConfigList>>
        get() = javaResource.configLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Integration mode. Valid values:
     * * paasSDK: Integrated SDK.
     * * standardRoom: Model Room.
     */
    public val integrationMode: Output<String>?
        get() = javaResource.integrationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Application Template scenario. Valid values: ["business", "classroom"].
     */
    public val scene: Output<String>?
        get() = javaResource.scene().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Application template usage status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AppTemplateMapper : ResourceMapper<AppTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.imp.AppTemplate::class == javaResource::class

    override fun map(javaResource: Resource): AppTemplate = AppTemplate(
        javaResource as
            com.pulumi.alicloud.imp.AppTemplate,
    )
}

/**
 * @see [AppTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AppTemplate].
 */
public suspend fun appTemplate(name: String, block: suspend AppTemplateResourceBuilder.() -> Unit): AppTemplate {
    val builder = AppTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AppTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun appTemplate(name: String): AppTemplate {
    val builder = AppTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
