@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin

import com.pulumi.alicloud.imp.AppTemplateArgs.builder
import com.pulumi.alicloud.imp.kotlin.inputs.AppTemplateConfigListArgs
import com.pulumi.alicloud.imp.kotlin.inputs.AppTemplateConfigListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Apsara Agile Live (IMP) App Template resource.
 * For information about Apsara Agile Live (IMP) App Template and how to use it, see [What is App Template](https://help.aliyun.com/document_detail/270121.html).
 * > **NOTE:** Available in v1.137.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const example = new alicloud.imp.AppTemplate("example", {
 *     appTemplateName: "example_value",
 *     componentLists: [
 *         "component.live",
 *         "component.liveRecord",
 *     ],
 *     integrationMode: "paasSDK",
 *     scene: "business",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * example = alicloud.imp.AppTemplate("example",
 *     app_template_name="example_value",
 *     component_lists=[
 *         "component.live",
 *         "component.liveRecord",
 *     ],
 *     integration_mode="paasSDK",
 *     scene="business")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new AliCloud.Imp.AppTemplate("example", new()
 *     {
 *         AppTemplateName = "example_value",
 *         ComponentLists = new[]
 *         {
 *             "component.live",
 *             "component.liveRecord",
 *         },
 *         IntegrationMode = "paasSDK",
 *         Scene = "business",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/imp"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imp.NewAppTemplate(ctx, "example", &imp.AppTemplateArgs{
 * 			AppTemplateName: pulumi.String("example_value"),
 * 			ComponentLists: pulumi.StringArray{
 * 				pulumi.String("component.live"),
 * 				pulumi.String("component.liveRecord"),
 * 			},
 * 			IntegrationMode: pulumi.String("paasSDK"),
 * 			Scene:           pulumi.String("business"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.imp.AppTemplate;
 * import com.pulumi.alicloud.imp.AppTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AppTemplate("example", AppTemplateArgs.builder()
 *             .appTemplateName("example_value")
 *             .componentLists(
 *                 "component.live",
 *                 "component.liveRecord")
 *             .integrationMode("paasSDK")
 *             .scene("business")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:imp:AppTemplate
 *     properties:
 *       appTemplateName: example_value
 *       componentLists:
 *         - component.live
 *         - component.liveRecord
 *       integrationMode: paasSDK
 *       scene: business
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Apsara Agile Live (IMP) App Template can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:imp/appTemplate:AppTemplate example <id>
 * ```
 * @property appTemplateName The name of the resource.
 * @property componentLists List of components. Its element valid values: ["component&#46;live","component&#46;liveRecord","component&#46;liveBeauty","component&#46;rtc","component&#46;rtcRecord","component&#46;im","component&#46;whiteboard","component&#46;liveSecurity","component&#46;chatSecurity"].
 * @property configLists Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
 * @property integrationMode Integration mode. Valid values:
 * * paasSDK: Integrated SDK.
 * * standardRoom: Model Room.
 * @property scene Application Template scenario. Valid values: ["business", "classroom"].
 */
public data class AppTemplateArgs(
    public val appTemplateName: Output<String>? = null,
    public val componentLists: Output<List<String>>? = null,
    public val configLists: Output<List<AppTemplateConfigListArgs>>? = null,
    public val integrationMode: Output<String>? = null,
    public val scene: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.imp.AppTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.imp.AppTemplateArgs =
        com.pulumi.alicloud.imp.AppTemplateArgs.builder()
            .appTemplateName(appTemplateName?.applyValue({ args0 -> args0 }))
            .componentLists(componentLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .configLists(
                configLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .integrationMode(integrationMode?.applyValue({ args0 -> args0 }))
            .scene(scene?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppTemplateArgs].
 */
@PulumiTagMarker
public class AppTemplateArgsBuilder internal constructor() {
    private var appTemplateName: Output<String>? = null

    private var componentLists: Output<List<String>>? = null

    private var configLists: Output<List<AppTemplateConfigListArgs>>? = null

    private var integrationMode: Output<String>? = null

    private var scene: Output<String>? = null

    /**
     * @param value The name of the resource.
     */
    @JvmName("fywrtlgrevnvuusm")
    public suspend fun appTemplateName(`value`: Output<String>) {
        this.appTemplateName = value
    }

    /**
     * @param value List of components. Its element valid values: ["component&#46;live","component&#46;liveRecord","component&#46;liveBeauty","component&#46;rtc","component&#46;rtcRecord","component&#46;im","component&#46;whiteboard","component&#46;liveSecurity","component&#46;chatSecurity"].
     */
    @JvmName("wyxwjhyndveljtxk")
    public suspend fun componentLists(`value`: Output<List<String>>) {
        this.componentLists = value
    }

    @JvmName("cggdevfninrginhq")
    public suspend fun componentLists(vararg values: Output<String>) {
        this.componentLists = Output.all(values.asList())
    }

    /**
     * @param values List of components. Its element valid values: ["component&#46;live","component&#46;liveRecord","component&#46;liveBeauty","component&#46;rtc","component&#46;rtcRecord","component&#46;im","component&#46;whiteboard","component&#46;liveSecurity","component&#46;chatSecurity"].
     */
    @JvmName("erelgkhmvxppmrgw")
    public suspend fun componentLists(values: List<Output<String>>) {
        this.componentLists = Output.all(values)
    }

    /**
     * @param value Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("uqqcrekmrtvabmax")
    public suspend fun configLists(`value`: Output<List<AppTemplateConfigListArgs>>) {
        this.configLists = value
    }

    @JvmName("xwamuhysbfbukenp")
    public suspend fun configLists(vararg values: Output<AppTemplateConfigListArgs>) {
        this.configLists = Output.all(values.asList())
    }

    /**
     * @param values Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("yvnmulvvdyxlujcu")
    public suspend fun configLists(values: List<Output<AppTemplateConfigListArgs>>) {
        this.configLists = Output.all(values)
    }

    /**
     * @param value Integration mode. Valid values:
     * * paasSDK: Integrated SDK.
     * * standardRoom: Model Room.
     */
    @JvmName("pkhvoofpyovwfefh")
    public suspend fun integrationMode(`value`: Output<String>) {
        this.integrationMode = value
    }

    /**
     * @param value Application Template scenario. Valid values: ["business", "classroom"].
     */
    @JvmName("mfdtwyljymtinckj")
    public suspend fun scene(`value`: Output<String>) {
        this.scene = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("dstguaksxmyvbbsp")
    public suspend fun appTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appTemplateName = mapped
    }

    /**
     * @param value List of components. Its element valid values: ["component&#46;live","component&#46;liveRecord","component&#46;liveBeauty","component&#46;rtc","component&#46;rtcRecord","component&#46;im","component&#46;whiteboard","component&#46;liveSecurity","component&#46;chatSecurity"].
     */
    @JvmName("ofbllcvpyvydrcqm")
    public suspend fun componentLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.componentLists = mapped
    }

    /**
     * @param values List of components. Its element valid values: ["component&#46;live","component&#46;liveRecord","component&#46;liveBeauty","component&#46;rtc","component&#46;rtcRecord","component&#46;im","component&#46;whiteboard","component&#46;liveSecurity","component&#46;chatSecurity"].
     */
    @JvmName("upxupdugjmtjdpsl")
    public suspend fun componentLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentLists = mapped
    }

    /**
     * @param value Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("lwleicnapnufkspl")
    public suspend fun configLists(`value`: List<AppTemplateConfigListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configLists = mapped
    }

    /**
     * @param argument Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("ywmlxfntopdyaohd")
    public suspend fun configLists(argument: List<suspend AppTemplateConfigListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AppTemplateConfigListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configLists = mapped
    }

    /**
     * @param argument Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("ovjxnruftalpskkk")
    public suspend fun configLists(vararg argument: suspend AppTemplateConfigListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AppTemplateConfigListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.configLists = mapped
    }

    /**
     * @param argument Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("tjweopqutsuorlda")
    public suspend fun configLists(argument: suspend AppTemplateConfigListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AppTemplateConfigListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.configLists = mapped
    }

    /**
     * @param values Configuration list. It have several default configs after the resource is created. See the following `Block config_list`.
     */
    @JvmName("wlhwaxuketjayiye")
    public suspend fun configLists(vararg values: AppTemplateConfigListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.configLists = mapped
    }

    /**
     * @param value Integration mode. Valid values:
     * * paasSDK: Integrated SDK.
     * * standardRoom: Model Room.
     */
    @JvmName("afugbvqbyxfbcaqi")
    public suspend fun integrationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integrationMode = mapped
    }

    /**
     * @param value Application Template scenario. Valid values: ["business", "classroom"].
     */
    @JvmName("onxqfuayvitwnoee")
    public suspend fun scene(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scene = mapped
    }

    internal fun build(): AppTemplateArgs = AppTemplateArgs(
        appTemplateName = appTemplateName,
        componentLists = componentLists,
        configLists = configLists,
        integrationMode = integrationMode,
        scene = scene,
    )
}
