@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin

import com.pulumi.alicloud.imp.ImpFunctions.getAppTemplatesPlain
import com.pulumi.alicloud.imp.kotlin.inputs.GetAppTemplatesPlainArgs
import com.pulumi.alicloud.imp.kotlin.inputs.GetAppTemplatesPlainArgsBuilder
import com.pulumi.alicloud.imp.kotlin.outputs.GetAppTemplatesResult
import com.pulumi.alicloud.imp.kotlin.outputs.GetAppTemplatesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object ImpFunctions {
    /**
     * This data source provides the Imp App Templates of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.137.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.imp.getAppTemplates({});
     * export const impAppTemplateId1 = ids.then(ids => ids.templates?.[0]?.id);
     * const nameRegex = alicloud.imp.getAppTemplates({
     *     nameRegex: "^my_AppTemplate",
     * });
     * export const impAppTemplateId2 = nameRegex.then(nameRegex => nameRegex.templates?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.imp.get_app_templates()
     * pulumi.export("impAppTemplateId1", ids.templates[0].id)
     * name_regex = alicloud.imp.get_app_templates(name_regex="^my_AppTemplate")
     * pulumi.export("impAppTemplateId2", name_regex.templates[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Imp.GetAppTemplates.Invoke();
     *     var nameRegex = AliCloud.Imp.GetAppTemplates.Invoke(new()
     *     {
     *         NameRegex = "^my_AppTemplate",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["impAppTemplateId1"] = ids&#46;Apply(getAppTemplatesResult => getAppTemplatesResult&#46;Templates[0]?.Id),
     *         ["impAppTemplateId2"] = nameRegex&#46;Apply(getAppTemplatesResult => getAppTemplatesResult&#46;Templates[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/imp"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := imp.GetAppTemplates(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("impAppTemplateId1", ids.Templates[0].Id)
     * 		nameRegex, err := imp.GetAppTemplates(ctx, &imp.GetAppTemplatesArgs{
     * 			NameRegex: pulumi.StringRef("^my_AppTemplate"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("impAppTemplateId2", nameRegex.Templates[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.imp.ImpFunctions;
     * import com.pulumi.alicloud.imp.inputs.GetAppTemplatesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = ImpFunctions.getAppTemplates();
     *         ctx.export("impAppTemplateId1", ids.applyValue(getAppTemplatesResult -> getAppTemplatesResult.templates()[0].id()));
     *         final var nameRegex = ImpFunctions.getAppTemplates(GetAppTemplatesArgs.builder()
     *             .nameRegex("^my_AppTemplate")
     *             .build());
     *         ctx.export("impAppTemplateId2", nameRegex.applyValue(getAppTemplatesResult -> getAppTemplatesResult.templates()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:imp:getAppTemplates
     *       Arguments: {}
     *   nameRegex:
     *     fn::invoke:
     *       Function: alicloud:imp:getAppTemplates
     *       Arguments:
     *         nameRegex: ^my_AppTemplate
     * outputs:
     *   impAppTemplateId1: ${ids.templates[0].id}
     *   impAppTemplateId2: ${nameRegex.templates[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAppTemplates.
     * @return A collection of values returned by getAppTemplates.
     */
    public suspend fun getAppTemplates(argument: GetAppTemplatesPlainArgs): GetAppTemplatesResult =
        toKotlin(getAppTemplatesPlain(argument.toJava()).await())

    /**
     * @see [getAppTemplates].
     * @param ids A list of App Template IDs.
     * @param nameRegex A regex string to filter results by App Template name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Application template usage status. Valid values: ["attached", "unattached"].
     * @return A collection of values returned by getAppTemplates.
     */
    public suspend fun getAppTemplates(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetAppTemplatesResult {
        val argument = GetAppTemplatesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            status = status,
        )
        return toKotlin(getAppTemplatesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAppTemplates].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;imp&#46;kotlin&#46;inputs&#46;GetAppTemplatesPlainArgs].
     * @return A collection of values returned by getAppTemplates.
     */
    public suspend fun getAppTemplates(argument: suspend GetAppTemplatesPlainArgsBuilder.() -> Unit): GetAppTemplatesResult {
        val builder = GetAppTemplatesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAppTemplatesPlain(builtArgument.toJava()).await())
    }
}
