@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin.inputs

import com.pulumi.alicloud.imp.inputs.AppTemplateConfigListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Configuration item key. Valid values: ["config&#46;appCallbackAuthKey","config&#46;appCallbackUrl","config&#46;callbackClass&#46;live","config&#46;callbackClass&#46;user","config&#46;livePullDomain","config&#46;livePushDomain","config&#46;multipleClientsLogin","config&#46;regionId","config&#46;streamChangeCallbackUrl"].
 * @property value Configuration item content.
 * > **NOTE:**  By default, the attribute `config_list` will return all of nine keys with empty value. If you want to set one or more of the key's value, you had better also set other keys, otherwise, there will be a diff.
 */
public data class AppTemplateConfigListArgs(
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.imp.inputs.AppTemplateConfigListArgs> {
    override fun toJava(): com.pulumi.alicloud.imp.inputs.AppTemplateConfigListArgs =
        com.pulumi.alicloud.imp.inputs.AppTemplateConfigListArgs.builder()
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppTemplateConfigListArgs].
 */
@PulumiTagMarker
public class AppTemplateConfigListArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Configuration item key. Valid values: ["config&#46;appCallbackAuthKey","config&#46;appCallbackUrl","config&#46;callbackClass&#46;live","config&#46;callbackClass&#46;user","config&#46;livePullDomain","config&#46;livePushDomain","config&#46;multipleClientsLogin","config&#46;regionId","config&#46;streamChangeCallbackUrl"].
     */
    @JvmName("txlphcgnatnmpflx")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Configuration item content.
     * > **NOTE:**  By default, the attribute `config_list` will return all of nine keys with empty value. If you want to set one or more of the key's value, you had better also set other keys, otherwise, there will be a diff.
     */
    @JvmName("khlptohvvbbnkdin")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Configuration item key. Valid values: ["config&#46;appCallbackAuthKey","config&#46;appCallbackUrl","config&#46;callbackClass&#46;live","config&#46;callbackClass&#46;user","config&#46;livePullDomain","config&#46;livePushDomain","config&#46;multipleClientsLogin","config&#46;regionId","config&#46;streamChangeCallbackUrl"].
     */
    @JvmName("dmetbcshpyxwwtqu")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Configuration item content.
     * > **NOTE:**  By default, the attribute `config_list` will return all of nine keys with empty value. If you want to set one or more of the key's value, you had better also set other keys, otherwise, there will be a diff.
     */
    @JvmName("cfkywhbqgufdxudb")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): AppTemplateConfigListArgs = AppTemplateConfigListArgs(
        key = key,
        `value` = `value`,
    )
}
