@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin.inputs

import com.pulumi.alicloud.imp.inputs.GetAppTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAppTemplates.
 * @property ids A list of App Template IDs.
 * @property nameRegex A regex string to filter results by App Template name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Application template usage status. Valid values: ["attached", "unattached"].
 */
public data class GetAppTemplatesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.imp.inputs.GetAppTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.imp.inputs.GetAppTemplatesPlainArgs =
        com.pulumi.alicloud.imp.inputs.GetAppTemplatesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAppTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetAppTemplatesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of App Template IDs.
     */
    @JvmName("ksagojpvpuhfmwah")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of App Template IDs.
     */
    @JvmName("mgodldoaivuuidvb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by App Template name.
     */
    @JvmName("htvcjcfhuijpphqt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dkdmmcaglidfqytv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Application template usage status. Valid values: ["attached", "unattached"].
     */
    @JvmName("ycnawovirqyivhvc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetAppTemplatesPlainArgs = GetAppTemplatesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
    )
}
