@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAppTemplates.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property status
 * @property templates
 */
public data class GetAppTemplatesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val templates: List<GetAppTemplatesTemplate>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.imp.outputs.GetAppTemplatesResult): GetAppTemplatesResult = GetAppTemplatesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            templates = javaType.templates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.imp.kotlin.outputs.GetAppTemplatesTemplate.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
