@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.imp.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appTemplateCreator Apply template creator.
 * @property appTemplateId The first ID of the resource.
 * @property appTemplateName The name of the resource.
 * @property componentLists List of components.
 * @property configLists List of config.
 * @property createTime Creation time.
 * @property id The ID of the App Template.
 * @property integrationMode Integration mode (Integrated SDK:paasSDK, Model Room: standardRoom).
 * @property scene Application Template scenario, e-commerce business, classroom classroom.
 * @property sdkInfo SDK information.
 * @property standardRoomInfo Model room information.
 * @property status Application template usage status.
 */
public data class GetAppTemplatesTemplate(
    public val appTemplateCreator: String,
    public val appTemplateId: String,
    public val appTemplateName: String,
    public val componentLists: List<String>,
    public val configLists: List<GetAppTemplatesTemplateConfigList>,
    public val createTime: String,
    public val id: String,
    public val integrationMode: String,
    public val scene: String,
    public val sdkInfo: String,
    public val standardRoomInfo: String,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.imp.outputs.GetAppTemplatesTemplate): GetAppTemplatesTemplate = GetAppTemplatesTemplate(
            appTemplateCreator = javaType.appTemplateCreator(),
            appTemplateId = javaType.appTemplateId(),
            appTemplateName = javaType.appTemplateName(),
            componentLists = javaType.componentLists().map({ args0 -> args0 }),
            configLists = javaType.configLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.imp.kotlin.outputs.GetAppTemplatesTemplateConfigList.Companion.toKotlin(args0)
                })
            }),
            createTime = javaType.createTime(),
            id = javaType.id(),
            integrationMode = javaType.integrationMode(),
            scene = javaType.scene(),
            sdkInfo = javaType.sdkInfo(),
            standardRoomInfo = javaType.standardRoomInfo(),
            status = javaType.status(),
        )
    }
}
