@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ims.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [OidcProvider].
 */
@PulumiTagMarker
public class OidcProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OidcProviderArgs = OidcProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OidcProviderArgsBuilder.() -> Unit) {
        val builder = OidcProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OidcProvider {
        val builtJavaResource = com.pulumi.alicloud.ims.OidcProvider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OidcProvider(builtJavaResource)
    }
}

/**
 * Provides a IMS Oidc Provider resource. OpenID Connect Provider.
 * For information about IMS Oidc Provider and how to use it, see [What is Oidc Provider](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ims-2019-08-15-createoidcprovider).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const oidcProviderName = config.get("oidcProviderName") || "amp-resource-example-oidc-provider";
 * const _default = new alicloud.ims.OidcProvider("default", {
 *     description: oidcProviderName,
 *     issuerUrl: "https://oauth.aliyun.com",
 *     fingerprints: ["902ef2deeb3c5b13ea4c3d5193629309e231ae55"],
 *     issuanceLimitTime: 12,
 *     oidcProviderName: name,
 *     clientIds: [
 *         "123",
 *         "456",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * oidc_provider_name = config.get("oidcProviderName")
 * if oidc_provider_name is None:
 *     oidc_provider_name = "amp-resource-example-oidc-provider"
 * default = alicloud.ims.OidcProvider("default",
 *     description=oidc_provider_name,
 *     issuer_url="https://oauth.aliyun.com",
 *     fingerprints=["902ef2deeb3c5b13ea4c3d5193629309e231ae55"],
 *     issuance_limit_time=12,
 *     oidc_provider_name=name,
 *     client_ids=[
 *         "123",
 *         "456",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var oidcProviderName = config.Get("oidcProviderName") ?? "amp-resource-example-oidc-provider";
 *     var @default = new AliCloud.Ims.OidcProvider("default", new()
 *     {
 *         Description = oidcProviderName,
 *         IssuerUrl = "https://oauth.aliyun.com",
 *         Fingerprints = new[]
 *         {
 *             "902ef2deeb3c5b13ea4c3d5193629309e231ae55",
 *         },
 *         IssuanceLimitTime = 12,
 *         OidcProviderName = name,
 *         ClientIds = new[]
 *         {
 *             "123",
 *             "456",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ims"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		oidcProviderName := "amp-resource-example-oidc-provider"
 * 		if param := cfg.Get("oidcProviderName"); param != "" {
 * 			oidcProviderName = param
 * 		}
 * 		_, err := ims.NewOidcProvider(ctx, "default", &ims.OidcProviderArgs{
 * 			Description: pulumi.String(oidcProviderName),
 * 			IssuerUrl:   pulumi.String("https://oauth.aliyun.com"),
 * 			Fingerprints: pulumi.StringArray{
 * 				pulumi.String("902ef2deeb3c5b13ea4c3d5193629309e231ae55"),
 * 			},
 * 			IssuanceLimitTime: pulumi.Int(12),
 * 			OidcProviderName:  pulumi.String(name),
 * 			ClientIds: pulumi.StringArray{
 * 				pulumi.String("123"),
 * 				pulumi.String("456"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ims.OidcProvider;
 * import com.pulumi.alicloud.ims.OidcProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var oidcProviderName = config.get("oidcProviderName").orElse("amp-resource-example-oidc-provider");
 *         var default_ = new OidcProvider("default", OidcProviderArgs.builder()
 *             .description(oidcProviderName)
 *             .issuerUrl("https://oauth.aliyun.com")
 *             .fingerprints("902ef2deeb3c5b13ea4c3d5193629309e231ae55")
 *             .issuanceLimitTime("12")
 *             .oidcProviderName(name)
 *             .clientIds(
 *                 "123",
 *                 "456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   oidcProviderName:
 *     type: string
 *     default: amp-resource-example-oidc-provider
 * resources:
 *   default:
 *     type: alicloud:ims:OidcProvider
 *     properties:
 *       description: ${oidcProviderName}
 *       issuerUrl: https://oauth.aliyun.com
 *       fingerprints:
 *         - 902ef2deeb3c5b13ea4c3d5193629309e231ae55
 *       issuanceLimitTime: '12'
 *       oidcProviderName: ${name}
 *       clientIds:
 *         - '123'
 *         - '456'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * IMS Oidc Provider can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ims/oidcProvider:OidcProvider example <id>
 * ```
 */
public class OidcProvider internal constructor(
    override val javaResource: com.pulumi.alicloud.ims.OidcProvider,
) : KotlinCustomResource(javaResource, OidcProviderMapper) {
    /**
     * Client ID.
     */
    public val clientIds: Output<List<String>>?
        get() = javaResource.clientIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Creation Time (UTC time).
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Description of OIDC identity provider.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authentication fingerprint of the HTTPS CA certificate.
     */
    public val fingerprints: Output<List<String>>?
        get() = javaResource.fingerprints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The earliest time when an external IdP is allowed to issue an ID Token. If the iat field in the ID Token is greater than the current time, the request is rejected.Unit: hours. Value range: 1~168.
     */
    public val issuanceLimitTime: Output<Int>
        get() = javaResource.issuanceLimitTime().applyValue({ args0 -> args0 })

    /**
     * The issuer URL of the OIDC identity provider.
     */
    public val issuerUrl: Output<String>
        get() = javaResource.issuerUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the OIDC identity provider.
     */
    public val oidcProviderName: Output<String>
        get() = javaResource.oidcProviderName().applyValue({ args0 -> args0 })
}

public object OidcProviderMapper : ResourceMapper<OidcProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.ims.OidcProvider::class == javaResource::class

    override fun map(javaResource: Resource): OidcProvider = OidcProvider(
        javaResource as
            com.pulumi.alicloud.ims.OidcProvider,
    )
}

/**
 * @see [OidcProvider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OidcProvider].
 */
public suspend fun oidcProvider(
    name: String,
    block: suspend OidcProviderResourceBuilder.() -> Unit,
): OidcProvider {
    val builder = OidcProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OidcProvider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun oidcProvider(name: String): OidcProvider {
    val builder = OidcProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
