@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.ims.kotlin

import com.pulumi.alicloud.ims.OidcProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a IMS Oidc Provider resource. OpenID Connect Provider.
 * For information about IMS Oidc Provider and how to use it, see [What is Oidc Provider](https://www.alibabacloud.com/help/en/ram/developer-reference/api-ims-2019-08-15-createoidcprovider).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const oidcProviderName = config.get("oidcProviderName") || "amp-resource-example-oidc-provider";
 * const _default = new alicloud.ims.OidcProvider("default", {
 *     description: oidcProviderName,
 *     issuerUrl: "https://oauth.aliyun.com",
 *     fingerprints: ["902ef2deeb3c5b13ea4c3d5193629309e231ae55"],
 *     issuanceLimitTime: 12,
 *     oidcProviderName: name,
 *     clientIds: [
 *         "123",
 *         "456",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * oidc_provider_name = config.get("oidcProviderName")
 * if oidc_provider_name is None:
 *     oidc_provider_name = "amp-resource-example-oidc-provider"
 * default = alicloud.ims.OidcProvider("default",
 *     description=oidc_provider_name,
 *     issuer_url="https://oauth.aliyun.com",
 *     fingerprints=["902ef2deeb3c5b13ea4c3d5193629309e231ae55"],
 *     issuance_limit_time=12,
 *     oidc_provider_name=name,
 *     client_ids=[
 *         "123",
 *         "456",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var oidcProviderName = config.Get("oidcProviderName") ?? "amp-resource-example-oidc-provider";
 *     var @default = new AliCloud.Ims.OidcProvider("default", new()
 *     {
 *         Description = oidcProviderName,
 *         IssuerUrl = "https://oauth.aliyun.com",
 *         Fingerprints = new[]
 *         {
 *             "902ef2deeb3c5b13ea4c3d5193629309e231ae55",
 *         },
 *         IssuanceLimitTime = 12,
 *         OidcProviderName = name,
 *         ClientIds = new[]
 *         {
 *             "123",
 *             "456",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/ims"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		oidcProviderName := "amp-resource-example-oidc-provider"
 * 		if param := cfg.Get("oidcProviderName"); param != "" {
 * 			oidcProviderName = param
 * 		}
 * 		_, err := ims.NewOidcProvider(ctx, "default", &ims.OidcProviderArgs{
 * 			Description: pulumi.String(oidcProviderName),
 * 			IssuerUrl:   pulumi.String("https://oauth.aliyun.com"),
 * 			Fingerprints: pulumi.StringArray{
 * 				pulumi.String("902ef2deeb3c5b13ea4c3d5193629309e231ae55"),
 * 			},
 * 			IssuanceLimitTime: pulumi.Int(12),
 * 			OidcProviderName:  pulumi.String(name),
 * 			ClientIds: pulumi.StringArray{
 * 				pulumi.String("123"),
 * 				pulumi.String("456"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.ims.OidcProvider;
 * import com.pulumi.alicloud.ims.OidcProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var oidcProviderName = config.get("oidcProviderName").orElse("amp-resource-example-oidc-provider");
 *         var default_ = new OidcProvider("default", OidcProviderArgs.builder()
 *             .description(oidcProviderName)
 *             .issuerUrl("https://oauth.aliyun.com")
 *             .fingerprints("902ef2deeb3c5b13ea4c3d5193629309e231ae55")
 *             .issuanceLimitTime("12")
 *             .oidcProviderName(name)
 *             .clientIds(
 *                 "123",
 *                 "456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 *   oidcProviderName:
 *     type: string
 *     default: amp-resource-example-oidc-provider
 * resources:
 *   default:
 *     type: alicloud:ims:OidcProvider
 *     properties:
 *       description: ${oidcProviderName}
 *       issuerUrl: https://oauth.aliyun.com
 *       fingerprints:
 *         - 902ef2deeb3c5b13ea4c3d5193629309e231ae55
 *       issuanceLimitTime: '12'
 *       oidcProviderName: ${name}
 *       clientIds:
 *         - '123'
 *         - '456'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * IMS Oidc Provider can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:ims/oidcProvider:OidcProvider example <id>
 * ```
 * @property clientIds Client ID.
 * @property description Description of OIDC identity provider.
 * @property fingerprints The authentication fingerprint of the HTTPS CA certificate.
 * @property issuanceLimitTime The earliest time when an external IdP is allowed to issue an ID Token. If the iat field in the ID Token is greater than the current time, the request is rejected.Unit: hours. Value range: 1~168.
 * @property issuerUrl The issuer URL of the OIDC identity provider.
 * @property oidcProviderName The name of the OIDC identity provider.
 */
public data class OidcProviderArgs(
    public val clientIds: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val fingerprints: Output<List<String>>? = null,
    public val issuanceLimitTime: Output<Int>? = null,
    public val issuerUrl: Output<String>? = null,
    public val oidcProviderName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.ims.OidcProviderArgs> {
    override fun toJava(): com.pulumi.alicloud.ims.OidcProviderArgs =
        com.pulumi.alicloud.ims.OidcProviderArgs.builder()
            .clientIds(clientIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fingerprints(fingerprints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .issuanceLimitTime(issuanceLimitTime?.applyValue({ args0 -> args0 }))
            .issuerUrl(issuerUrl?.applyValue({ args0 -> args0 }))
            .oidcProviderName(oidcProviderName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OidcProviderArgs].
 */
@PulumiTagMarker
public class OidcProviderArgsBuilder internal constructor() {
    private var clientIds: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var fingerprints: Output<List<String>>? = null

    private var issuanceLimitTime: Output<Int>? = null

    private var issuerUrl: Output<String>? = null

    private var oidcProviderName: Output<String>? = null

    /**
     * @param value Client ID.
     */
    @JvmName("qhkfeljucypyqsps")
    public suspend fun clientIds(`value`: Output<List<String>>) {
        this.clientIds = value
    }

    @JvmName("obirxssubhdalivm")
    public suspend fun clientIds(vararg values: Output<String>) {
        this.clientIds = Output.all(values.asList())
    }

    /**
     * @param values Client ID.
     */
    @JvmName("bljbvqdtugkqtsko")
    public suspend fun clientIds(values: List<Output<String>>) {
        this.clientIds = Output.all(values)
    }

    /**
     * @param value Description of OIDC identity provider.
     */
    @JvmName("lrjecqcjmpcylsdd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The authentication fingerprint of the HTTPS CA certificate.
     */
    @JvmName("glfesyhxjkhmxdwu")
    public suspend fun fingerprints(`value`: Output<List<String>>) {
        this.fingerprints = value
    }

    @JvmName("mbpqeydiwjwofjoj")
    public suspend fun fingerprints(vararg values: Output<String>) {
        this.fingerprints = Output.all(values.asList())
    }

    /**
     * @param values The authentication fingerprint of the HTTPS CA certificate.
     */
    @JvmName("oomlmxbbfgeyyxgl")
    public suspend fun fingerprints(values: List<Output<String>>) {
        this.fingerprints = Output.all(values)
    }

    /**
     * @param value The earliest time when an external IdP is allowed to issue an ID Token. If the iat field in the ID Token is greater than the current time, the request is rejected.Unit: hours. Value range: 1~168.
     */
    @JvmName("djboerpbfsfthtxp")
    public suspend fun issuanceLimitTime(`value`: Output<Int>) {
        this.issuanceLimitTime = value
    }

    /**
     * @param value The issuer URL of the OIDC identity provider.
     */
    @JvmName("oyygbqwrujfhfkya")
    public suspend fun issuerUrl(`value`: Output<String>) {
        this.issuerUrl = value
    }

    /**
     * @param value The name of the OIDC identity provider.
     */
    @JvmName("hymqvlubtqomtoox")
    public suspend fun oidcProviderName(`value`: Output<String>) {
        this.oidcProviderName = value
    }

    /**
     * @param value Client ID.
     */
    @JvmName("lsclfuklqpygxomr")
    public suspend fun clientIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientIds = mapped
    }

    /**
     * @param values Client ID.
     */
    @JvmName("rpbcikxwgoaofiap")
    public suspend fun clientIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientIds = mapped
    }

    /**
     * @param value Description of OIDC identity provider.
     */
    @JvmName("iiqqawqcrcyiduny")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The authentication fingerprint of the HTTPS CA certificate.
     */
    @JvmName("wbxfasfmfnbnccfh")
    public suspend fun fingerprints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fingerprints = mapped
    }

    /**
     * @param values The authentication fingerprint of the HTTPS CA certificate.
     */
    @JvmName("qbditvdbxpsemutj")
    public suspend fun fingerprints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fingerprints = mapped
    }

    /**
     * @param value The earliest time when an external IdP is allowed to issue an ID Token. If the iat field in the ID Token is greater than the current time, the request is rejected.Unit: hours. Value range: 1~168.
     */
    @JvmName("iohervwdprajaopk")
    public suspend fun issuanceLimitTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuanceLimitTime = mapped
    }

    /**
     * @param value The issuer URL of the OIDC identity provider.
     */
    @JvmName("hbxghtfmlobnmeuo")
    public suspend fun issuerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuerUrl = mapped
    }

    /**
     * @param value The name of the OIDC identity provider.
     */
    @JvmName("ekfkmlpolqnjdhyt")
    public suspend fun oidcProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcProviderName = mapped
    }

    internal fun build(): OidcProviderArgs = OidcProviderArgs(
        clientIds = clientIds,
        description = description,
        fingerprints = fingerprints,
        issuanceLimitTime = issuanceLimitTime,
        issuerUrl = issuerUrl,
        oidcProviderName = oidcProviderName,
    )
}
