@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.iot.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DeviceGroup].
 */
@PulumiTagMarker
public class DeviceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceGroupArgs = DeviceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceGroupArgsBuilder.() -> Unit) {
        val builder = DeviceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeviceGroup {
        val builtJavaResource = com.pulumi.alicloud.iot.DeviceGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeviceGroup(builtJavaResource)
    }
}

/**
 * Provides a Iot Device Group resource.
 * For information about Iot Device Group and how to use it, see [What is Device Group](https://www.alibabacloud.com/help/product/30520.htm).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.iot.DeviceGroup("example", {groupName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.iot.DeviceGroup("example", group_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.Iot.DeviceGroup("example", new()
 *     {
 *         GroupName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := iot.NewDeviceGroup(ctx, "example", &iot.DeviceGroupArgs{
 * 			GroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.iot.DeviceGroup;
 * import com.pulumi.alicloud.iot.DeviceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new DeviceGroup("example", DeviceGroupArgs.builder()
 *             .groupName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:iot:DeviceGroup
 *     properties:
 *       groupName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Iot Device Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:iot/deviceGroup:DeviceGroup example <id>
 * ```
 */
public class DeviceGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.iot.DeviceGroup,
) : KotlinCustomResource(javaResource, DeviceGroupMapper) {
    /**
     * The GroupDesc of the device group.
     */
    public val groupDesc: Output<String>?
        get() = javaResource.groupDesc().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The GroupName of the device group.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * The id of the Iot Instance.
     */
    public val iotInstanceId: Output<String>?
        get() = javaResource.iotInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the SuperGroup.
     */
    public val superGroupId: Output<String>?
        get() = javaResource.superGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DeviceGroupMapper : ResourceMapper<DeviceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.iot.DeviceGroup::class == javaResource::class

    override fun map(javaResource: Resource): DeviceGroup = DeviceGroup(
        javaResource as
            com.pulumi.alicloud.iot.DeviceGroup,
    )
}

/**
 * @see [DeviceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeviceGroup].
 */
public suspend fun deviceGroup(name: String, block: suspend DeviceGroupResourceBuilder.() -> Unit): DeviceGroup {
    val builder = DeviceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeviceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deviceGroup(name: String): DeviceGroup {
    val builder = DeviceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
