@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.iot.kotlin

import com.pulumi.alicloud.iot.DeviceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Iot Device Group resource.
 * For information about Iot Device Group and how to use it, see [What is Device Group](https://www.alibabacloud.com/help/product/30520.htm).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tfexample";
 * const example = new alicloud.iot.DeviceGroup("example", {groupName: name});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tfexample"
 * example = alicloud.iot.DeviceGroup("example", group_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tfexample";
 *     var example = new AliCloud.Iot.DeviceGroup("example", new()
 *     {
 *         GroupName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/iot"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tfexample"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := iot.NewDeviceGroup(ctx, "example", &iot.DeviceGroupArgs{
 * 			GroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.iot.DeviceGroup;
 * import com.pulumi.alicloud.iot.DeviceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tfexample");
 *         var example = new DeviceGroup("example", DeviceGroupArgs.builder()
 *             .groupName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tfexample
 * resources:
 *   example:
 *     type: alicloud:iot:DeviceGroup
 *     properties:
 *       groupName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Iot Device Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:iot/deviceGroup:DeviceGroup example <id>
 * ```
 * @property groupDesc The GroupDesc of the device group.
 * @property groupName The GroupName of the device group.
 * @property iotInstanceId The id of the Iot Instance.
 * @property superGroupId The id of the SuperGroup.
 */
public data class DeviceGroupArgs(
    public val groupDesc: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val iotInstanceId: Output<String>? = null,
    public val superGroupId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.iot.DeviceGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.iot.DeviceGroupArgs =
        com.pulumi.alicloud.iot.DeviceGroupArgs.builder()
            .groupDesc(groupDesc?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .iotInstanceId(iotInstanceId?.applyValue({ args0 -> args0 }))
            .superGroupId(superGroupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceGroupArgs].
 */
@PulumiTagMarker
public class DeviceGroupArgsBuilder internal constructor() {
    private var groupDesc: Output<String>? = null

    private var groupName: Output<String>? = null

    private var iotInstanceId: Output<String>? = null

    private var superGroupId: Output<String>? = null

    /**
     * @param value The GroupDesc of the device group.
     */
    @JvmName("cutieluqssbdoxir")
    public suspend fun groupDesc(`value`: Output<String>) {
        this.groupDesc = value
    }

    /**
     * @param value The GroupName of the device group.
     */
    @JvmName("dogbxcwtkopgeifp")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The id of the Iot Instance.
     */
    @JvmName("jfortqkpyvepaacs")
    public suspend fun iotInstanceId(`value`: Output<String>) {
        this.iotInstanceId = value
    }

    /**
     * @param value The id of the SuperGroup.
     */
    @JvmName("flxpqmdxkdbupbhn")
    public suspend fun superGroupId(`value`: Output<String>) {
        this.superGroupId = value
    }

    /**
     * @param value The GroupDesc of the device group.
     */
    @JvmName("kxasrelteklwrbwt")
    public suspend fun groupDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupDesc = mapped
    }

    /**
     * @param value The GroupName of the device group.
     */
    @JvmName("wrebcvboytnfcirf")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The id of the Iot Instance.
     */
    @JvmName("uenkqjkuuxixaxgc")
    public suspend fun iotInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotInstanceId = mapped
    }

    /**
     * @param value The id of the SuperGroup.
     */
    @JvmName("idjetktekjoainbp")
    public suspend fun superGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.superGroupId = mapped
    }

    internal fun build(): DeviceGroupArgs = DeviceGroupArgs(
        groupDesc = groupDesc,
        groupName = groupName,
        iotInstanceId = iotInstanceId,
        superGroupId = superGroupId,
    )
}
