@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.iot.kotlin

import com.pulumi.alicloud.iot.IotFunctions.getDeviceGroupsPlain
import com.pulumi.alicloud.iot.IotFunctions.getServicePlain
import com.pulumi.alicloud.iot.kotlin.inputs.GetDeviceGroupsPlainArgs
import com.pulumi.alicloud.iot.kotlin.inputs.GetDeviceGroupsPlainArgsBuilder
import com.pulumi.alicloud.iot.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.iot.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.iot.kotlin.outputs.GetDeviceGroupsResult
import com.pulumi.alicloud.iot.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.iot.kotlin.outputs.GetDeviceGroupsResult.Companion.toKotlin as getDeviceGroupsResultToKotlin
import com.pulumi.alicloud.iot.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object IotFunctions {
    /**
     * This data source provides the Iot Device Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.iot.getDeviceGroups({});
     * export const iotDeviceGroupId1 = ids.then(ids => ids.groups?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.iot.get_device_groups()
     * pulumi.export("iotDeviceGroupId1", ids.groups[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Iot.GetDeviceGroups.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["iotDeviceGroupId1"] = ids&#46;Apply(getDeviceGroupsResult => getDeviceGroupsResult&#46;Groups[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/iot"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := iot.GetDeviceGroups(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("iotDeviceGroupId1", ids.Groups[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.iot.IotFunctions;
     * import com.pulumi.alicloud.iot.inputs.GetDeviceGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = IotFunctions.getDeviceGroups();
     *         ctx.export("iotDeviceGroupId1", ids.applyValue(getDeviceGroupsResult -> getDeviceGroupsResult.groups()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:iot:getDeviceGroups
     *       Arguments: {}
     * outputs:
     *   iotDeviceGroupId1: ${ids.groups[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDeviceGroups.
     * @return A collection of values returned by getDeviceGroups.
     */
    public suspend fun getDeviceGroups(argument: GetDeviceGroupsPlainArgs): GetDeviceGroupsResult =
        getDeviceGroupsResultToKotlin(getDeviceGroupsPlain(argument.toJava()).await())

    /**
     * @see [getDeviceGroups].
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param groupName The GroupName of the device group.
     * @param ids A list of device group IDs.
     * @param iotInstanceId The id of the Iot Instance.
     * @param nameRegex A regex string to filter CEN instances by name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param superGroupId The id of the SuperGroup.
     * @return A collection of values returned by getDeviceGroups.
     */
    public suspend fun getDeviceGroups(
        enableDetails: Boolean? = null,
        groupName: String? = null,
        ids: List<String>? = null,
        iotInstanceId: String? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        superGroupId: String? = null,
    ): GetDeviceGroupsResult {
        val argument = GetDeviceGroupsPlainArgs(
            enableDetails = enableDetails,
            groupName = groupName,
            ids = ids,
            iotInstanceId = iotInstanceId,
            nameRegex = nameRegex,
            outputFile = outputFile,
            superGroupId = superGroupId,
        )
        return getDeviceGroupsResultToKotlin(getDeviceGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDeviceGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;iot&#46;kotlin&#46;inputs&#46;GetDeviceGroupsPlainArgs].
     * @return A collection of values returned by getDeviceGroups.
     */
    public suspend fun getDeviceGroups(argument: suspend GetDeviceGroupsPlainArgsBuilder.() -> Unit): GetDeviceGroupsResult {
        val builder = GetDeviceGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDeviceGroupsResultToKotlin(getDeviceGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open IOT service automatically. If the service has been opened, it will return opened.
     * For information about IOT and how to use it, see [What is IOT](https://www.alibabacloud.com/help/en/product/30520.htm).
     * > **NOTE:** Available in v1.115.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.iot.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.iot.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Iot.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/iot"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := iot.GetService(ctx, &iot.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.iot.IotFunctions;
     * import com.pulumi.alicloud.iot.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = IotFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:iot:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: `On` or `Off`. Default to `Off`.
     * > **NOTE:** Setting `enable = "On"` to open the IOT service that means you have read and agreed the [IOT Terms of Service](https://help.aliyun.com/document_detail/44548.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;iot&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
