@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.iot.kotlin.inputs

import com.pulumi.alicloud.iot.inputs.GetDeviceGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDeviceGroups.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property groupName The GroupName of the device group.
 * @property ids A list of device group IDs.
 * @property iotInstanceId The id of the Iot Instance.
 * @property nameRegex A regex string to filter CEN instances by name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property superGroupId The id of the SuperGroup.
 */
public data class GetDeviceGroupsPlainArgs(
    public val enableDetails: Boolean? = null,
    public val groupName: String? = null,
    public val ids: List<String>? = null,
    public val iotInstanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val superGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.iot.inputs.GetDeviceGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.iot.inputs.GetDeviceGroupsPlainArgs =
        com.pulumi.alicloud.iot.inputs.GetDeviceGroupsPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .groupName(groupName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .iotInstanceId(iotInstanceId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .superGroupId(superGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeviceGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetDeviceGroupsPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var groupName: String? = null

    private var ids: List<String>? = null

    private var iotInstanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var superGroupId: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("ppwpmpodlsrrojca")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The GroupName of the device group.
     */
    @JvmName("mhafcwpmgvrdugkp")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupName = mapped
    }

    /**
     * @param value A list of device group IDs.
     */
    @JvmName("stwoewgqqcsgkqcy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of device group IDs.
     */
    @JvmName("orhxnbdqwfdqjgkc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The id of the Iot Instance.
     */
    @JvmName("fjdiaowpfidkrina")
    public suspend fun iotInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.iotInstanceId = mapped
    }

    /**
     * @param value A regex string to filter CEN instances by name.
     */
    @JvmName("jayvowirjpgwruct")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kfgciiyaotwnfriu")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The id of the SuperGroup.
     */
    @JvmName("cohstyylutdqhxep")
    public suspend fun superGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.superGroupId = mapped
    }

    internal fun build(): GetDeviceGroupsPlainArgs = GetDeviceGroupsPlainArgs(
        enableDetails = enableDetails,
        groupName = groupName,
        ids = ids,
        iotInstanceId = iotInstanceId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        superGroupId = superGroupId,
    )
}
