@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createTime The Group CreateTime.
 * @property deviceActive The Group Number of activated devices.
 * @property deviceCount The Group Total number of devices.
 * @property deviceOnline The Group Number of online devices.
 * @property errorMessage The Error_Message of the device group.
 * @property groupDesc The GroupDesc of the device group.
 * @property groupId The GroupId of the device group.
 * @property groupName The GroupName of the device group.
 * @property id The ID of the device group.
 * @property success Whether the call is successful.
 */
public data class GetDeviceGroupsGroup(
    public val createTime: String,
    public val deviceActive: String,
    public val deviceCount: String,
    public val deviceOnline: String,
    public val errorMessage: String,
    public val groupDesc: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val success: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.iot.outputs.GetDeviceGroupsGroup): GetDeviceGroupsGroup = GetDeviceGroupsGroup(
            createTime = javaType.createTime(),
            deviceActive = javaType.deviceActive(),
            deviceCount = javaType.deviceCount(),
            deviceOnline = javaType.deviceOnline(),
            errorMessage = javaType.errorMessage(),
            groupDesc = javaType.groupDesc(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            success = javaType.success(),
        )
    }
}
