@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.iot.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDeviceGroups.
 * @property enableDetails
 * @property groupName
 * @property groups
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property iotInstanceId
 * @property nameRegex
 * @property outputFile
 * @property superGroupId
 */
public data class GetDeviceGroupsResult(
    public val enableDetails: Boolean? = null,
    public val groupName: String? = null,
    public val groups: List<GetDeviceGroupsGroup>,
    public val id: String,
    public val ids: List<String>,
    public val iotInstanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val superGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.iot.outputs.GetDeviceGroupsResult): GetDeviceGroupsResult = GetDeviceGroupsResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            groupName = javaType.groupName().map({ args0 -> args0 }).orElse(null),
            groups = javaType.groups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.iot.kotlin.outputs.GetDeviceGroupsGroup.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            iotInstanceId = javaType.iotInstanceId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            superGroupId = javaType.superGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
