@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ApplicationAccessPoint].
 */
@PulumiTagMarker
public class ApplicationAccessPointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationAccessPointArgs = ApplicationAccessPointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationAccessPointArgsBuilder.() -> Unit) {
        val builder = ApplicationAccessPointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationAccessPoint {
        val builtJavaResource = com.pulumi.alicloud.kms.ApplicationAccessPoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationAccessPoint(builtJavaResource)
    }
}

/**
 * Provides a KMS Application Access Point resource. An application access point (AAP) is used to implement fine-grained access control for Key Management Service (KMS) resources. An application can access a KMS instance only after an AAP is created for the application. .
 * For information about KMS Application Access Point and how to use it, see [What is Application Access Point](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createapplicationaccesspoint).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.kms.ApplicationAccessPoint("default", {
 *     description: "example aap",
 *     applicationAccessPointName: name,
 *     policies: [
 *         "abc",
 *         "efg",
 *         "hfc",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.kms.ApplicationAccessPoint("default",
 *     description="example aap",
 *     application_access_point_name=name,
 *     policies=[
 *         "abc",
 *         "efg",
 *         "hfc",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Kms.ApplicationAccessPoint("default", new()
 *     {
 *         Description = "example aap",
 *         ApplicationAccessPointName = name,
 *         Policies = new[]
 *         {
 *             "abc",
 *             "efg",
 *             "hfc",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := kms.NewApplicationAccessPoint(ctx, "default", &kms.ApplicationAccessPointArgs{
 * 			Description:                pulumi.String("example aap"),
 * 			ApplicationAccessPointName: pulumi.String(name),
 * 			Policies: pulumi.StringArray{
 * 				pulumi.String("abc"),
 * 				pulumi.String("efg"),
 * 				pulumi.String("hfc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.ApplicationAccessPoint;
 * import com.pulumi.alicloud.kms.ApplicationAccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ApplicationAccessPoint("default", ApplicationAccessPointArgs.builder()
 *             .description("example aap")
 *             .applicationAccessPointName(name)
 *             .policies(
 *                 "abc",
 *                 "efg",
 *                 "hfc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:kms:ApplicationAccessPoint
 *     properties:
 *       description: example aap
 *       applicationAccessPointName: ${name}
 *       policies:
 *         - abc
 *         - efg
 *         - hfc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Application Access Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/applicationAccessPoint:ApplicationAccessPoint example <id>
 * ```
 */
public class ApplicationAccessPoint internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.ApplicationAccessPoint,
) : KotlinCustomResource(javaResource, ApplicationAccessPointMapper) {
    /**
     * Application Access Point Name.
     */
    public val applicationAccessPointName: Output<String>
        get() = javaResource.applicationAccessPointName().applyValue({ args0 -> args0 })

    /**
     * Description .
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policies that have bound to the Application Access Point (AAP).
     */
    public val policies: Output<List<String>>
        get() = javaResource.policies().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ApplicationAccessPointMapper : ResourceMapper<ApplicationAccessPoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.ApplicationAccessPoint::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationAccessPoint =
        ApplicationAccessPoint(javaResource as com.pulumi.alicloud.kms.ApplicationAccessPoint)
}

/**
 * @see [ApplicationAccessPoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationAccessPoint].
 */
public suspend fun applicationAccessPoint(
    name: String,
    block: suspend ApplicationAccessPointResourceBuilder.() -> Unit,
): ApplicationAccessPoint {
    val builder = ApplicationAccessPointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationAccessPoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationAccessPoint(name: String): ApplicationAccessPoint {
    val builder = ApplicationAccessPointResourceBuilder()
    builder.name(name)
    return builder.build()
}
