@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.ApplicationAccessPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a KMS Application Access Point resource. An application access point (AAP) is used to implement fine-grained access control for Key Management Service (KMS) resources. An application can access a KMS instance only after an AAP is created for the application. .
 * For information about KMS Application Access Point and how to use it, see [What is Application Access Point](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createapplicationaccesspoint).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.kms.ApplicationAccessPoint("default", {
 *     description: "example aap",
 *     applicationAccessPointName: name,
 *     policies: [
 *         "abc",
 *         "efg",
 *         "hfc",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.kms.ApplicationAccessPoint("default",
 *     description="example aap",
 *     application_access_point_name=name,
 *     policies=[
 *         "abc",
 *         "efg",
 *         "hfc",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Kms.ApplicationAccessPoint("default", new()
 *     {
 *         Description = "example aap",
 *         ApplicationAccessPointName = name,
 *         Policies = new[]
 *         {
 *             "abc",
 *             "efg",
 *             "hfc",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := kms.NewApplicationAccessPoint(ctx, "default", &kms.ApplicationAccessPointArgs{
 * 			Description:                pulumi.String("example aap"),
 * 			ApplicationAccessPointName: pulumi.String(name),
 * 			Policies: pulumi.StringArray{
 * 				pulumi.String("abc"),
 * 				pulumi.String("efg"),
 * 				pulumi.String("hfc"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.ApplicationAccessPoint;
 * import com.pulumi.alicloud.kms.ApplicationAccessPointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new ApplicationAccessPoint("default", ApplicationAccessPointArgs.builder()
 *             .description("example aap")
 *             .applicationAccessPointName(name)
 *             .policies(
 *                 "abc",
 *                 "efg",
 *                 "hfc")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:kms:ApplicationAccessPoint
 *     properties:
 *       description: example aap
 *       applicationAccessPointName: ${name}
 *       policies:
 *         - abc
 *         - efg
 *         - hfc
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Application Access Point can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/applicationAccessPoint:ApplicationAccessPoint example <id>
 * ```
 * @property applicationAccessPointName Application Access Point Name.
 * @property description Description .
 * @property policies The policies that have bound to the Application Access Point (AAP).
 */
public data class ApplicationAccessPointArgs(
    public val applicationAccessPointName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val policies: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.ApplicationAccessPointArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.ApplicationAccessPointArgs =
        com.pulumi.alicloud.kms.ApplicationAccessPointArgs.builder()
            .applicationAccessPointName(applicationAccessPointName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .policies(policies?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationAccessPointArgs].
 */
@PulumiTagMarker
public class ApplicationAccessPointArgsBuilder internal constructor() {
    private var applicationAccessPointName: Output<String>? = null

    private var description: Output<String>? = null

    private var policies: Output<List<String>>? = null

    /**
     * @param value Application Access Point Name.
     */
    @JvmName("hfehwcdusvoatxvs")
    public suspend fun applicationAccessPointName(`value`: Output<String>) {
        this.applicationAccessPointName = value
    }

    /**
     * @param value Description .
     */
    @JvmName("vylakuaoskdflcfp")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The policies that have bound to the Application Access Point (AAP).
     */
    @JvmName("koiisswsdiuardlm")
    public suspend fun policies(`value`: Output<List<String>>) {
        this.policies = value
    }

    @JvmName("txhekersyouxkskr")
    public suspend fun policies(vararg values: Output<String>) {
        this.policies = Output.all(values.asList())
    }

    /**
     * @param values The policies that have bound to the Application Access Point (AAP).
     */
    @JvmName("iyvrplqtbadlqgkn")
    public suspend fun policies(values: List<Output<String>>) {
        this.policies = Output.all(values)
    }

    /**
     * @param value Application Access Point Name.
     */
    @JvmName("kppsjcsvsapgodvi")
    public suspend fun applicationAccessPointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationAccessPointName = mapped
    }

    /**
     * @param value Description .
     */
    @JvmName("ohjckgpfvjbiiifr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The policies that have bound to the Application Access Point (AAP).
     */
    @JvmName("lqkviaduaoxxoiks")
    public suspend fun policies(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    /**
     * @param values The policies that have bound to the Application Access Point (AAP).
     */
    @JvmName("jvdduxqrybbqbmsd")
    public suspend fun policies(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policies = mapped
    }

    internal fun build(): ApplicationAccessPointArgs = ApplicationAccessPointArgs(
        applicationAccessPointName = applicationAccessPointName,
        description = description,
        policies = policies,
    )
}
