@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ciphertext].
 */
@PulumiTagMarker
public class CiphertextResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CiphertextArgs = CiphertextArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CiphertextArgsBuilder.() -> Unit) {
        val builder = CiphertextArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ciphertext {
        val builtJavaResource = com.pulumi.alicloud.kms.Ciphertext(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ciphertext(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const key = new alicloud.kms.Key("key", {
 *     description: "example key",
 *     status: "Enabled",
 *     pendingWindowInDays: 7,
 * });
 * const encrypted = new alicloud.kms.Ciphertext("encrypted", {
 *     keyId: key.id,
 *     plaintext: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * key = alicloud.kms.Key("key",
 *     description="example key",
 *     status="Enabled",
 *     pending_window_in_days=7)
 * encrypted = alicloud.kms.Ciphertext("encrypted",
 *     key_id=key.id,
 *     plaintext="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new AliCloud.Kms.Key("key", new()
 *     {
 *         Description = "example key",
 *         Status = "Enabled",
 *         PendingWindowInDays = 7,
 *     });
 *     var encrypted = new AliCloud.Kms.Ciphertext("encrypted", new()
 *     {
 *         KeyId = key.Id,
 *         Plaintext = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
 * 			Description:         pulumi.String("example key"),
 * 			Status:              pulumi.String("Enabled"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewCiphertext(ctx, "encrypted", &kms.CiphertextArgs{
 * 			KeyId:     key.ID(),
 * 			Plaintext: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.kms.Ciphertext;
 * import com.pulumi.alicloud.kms.CiphertextArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .description("example key")
 *             .status("Enabled")
 *             .pendingWindowInDays(7)
 *             .build());
 *         var encrypted = new Ciphertext("encrypted", CiphertextArgs.builder()
 *             .keyId(key.id())
 *             .plaintext("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   key:
 *     type: alicloud:kms:Key
 *     properties:
 *       description: example key
 *       status: Enabled
 *       pendingWindowInDays: 7
 *   encrypted:
 *     type: alicloud:kms:Ciphertext
 *     properties:
 *       keyId: ${key.id}
 *       plaintext: example
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Ciphertext internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.Ciphertext,
) : KotlinCustomResource(javaResource, CiphertextMapper) {
    /**
     * The ciphertext of the data key encrypted with the primary CMK version.
     */
    public val ciphertextBlob: Output<String>
        get() = javaResource.ciphertextBlob().applyValue({ args0 -> args0 })

    /**
     * The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    public val encryptionContext: Output<Map<String, String>>?
        get() = javaResource.encryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * The globally unique ID of the CMK.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * The plaintext to be encrypted which must be encoded in Base64.
     */
    public val plaintext: Output<String>
        get() = javaResource.plaintext().applyValue({ args0 -> args0 })
}

public object CiphertextMapper : ResourceMapper<Ciphertext> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.Ciphertext::class == javaResource::class

    override fun map(javaResource: Resource): Ciphertext = Ciphertext(
        javaResource as
            com.pulumi.alicloud.kms.Ciphertext,
    )
}

/**
 * @see [Ciphertext].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ciphertext].
 */
public suspend fun ciphertext(name: String, block: suspend CiphertextResourceBuilder.() -> Unit): Ciphertext {
    val builder = CiphertextResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ciphertext].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ciphertext(name: String): Ciphertext {
    val builder = CiphertextResourceBuilder()
    builder.name(name)
    return builder.build()
}
