@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.CiphertextArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const key = new alicloud.kms.Key("key", {
 *     description: "example key",
 *     status: "Enabled",
 *     pendingWindowInDays: 7,
 * });
 * const encrypted = new alicloud.kms.Ciphertext("encrypted", {
 *     keyId: key.id,
 *     plaintext: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * key = alicloud.kms.Key("key",
 *     description="example key",
 *     status="Enabled",
 *     pending_window_in_days=7)
 * encrypted = alicloud.kms.Ciphertext("encrypted",
 *     key_id=key.id,
 *     plaintext="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var key = new AliCloud.Kms.Key("key", new()
 *     {
 *         Description = "example key",
 *         Status = "Enabled",
 *         PendingWindowInDays = 7,
 *     });
 *     var encrypted = new AliCloud.Kms.Ciphertext("encrypted", new()
 *     {
 *         KeyId = key.Id,
 *         Plaintext = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
 * 			Description:         pulumi.String("example key"),
 * 			Status:              pulumi.String("Enabled"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewCiphertext(ctx, "encrypted", &kms.CiphertextArgs{
 * 			KeyId:     key.ID(),
 * 			Plaintext: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import com.pulumi.alicloud.kms.Ciphertext;
 * import com.pulumi.alicloud.kms.CiphertextArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var key = new Key("key", KeyArgs.builder()
 *             .description("example key")
 *             .status("Enabled")
 *             .pendingWindowInDays(7)
 *             .build());
 *         var encrypted = new Ciphertext("encrypted", CiphertextArgs.builder()
 *             .keyId(key.id())
 *             .plaintext("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   key:
 *     type: alicloud:kms:Key
 *     properties:
 *       description: example key
 *       status: Enabled
 *       pendingWindowInDays: 7
 *   encrypted:
 *     type: alicloud:kms:Ciphertext
 *     properties:
 *       keyId: ${key.id}
 *       plaintext: example
 * ```
 * <!--End PulumiCodeChooser -->
 * @property encryptionContext The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
 * @property keyId The globally unique ID of the CMK.
 * @property plaintext The plaintext to be encrypted which must be encoded in Base64.
 */
public data class CiphertextArgs(
    public val encryptionContext: Output<Map<String, String>>? = null,
    public val keyId: Output<String>? = null,
    public val plaintext: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.CiphertextArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.CiphertextArgs =
        com.pulumi.alicloud.kms.CiphertextArgs.builder()
            .encryptionContext(
                encryptionContext?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .plaintext(plaintext?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CiphertextArgs].
 */
@PulumiTagMarker
public class CiphertextArgsBuilder internal constructor() {
    private var encryptionContext: Output<Map<String, String>>? = null

    private var keyId: Output<String>? = null

    private var plaintext: Output<String>? = null

    /**
     * @param value The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("erwmmixcnmpqtpjp")
    public suspend fun encryptionContext(`value`: Output<Map<String, String>>) {
        this.encryptionContext = value
    }

    /**
     * @param value The globally unique ID of the CMK.
     */
    @JvmName("gecrmtgpqsxvbpnl")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The plaintext to be encrypted which must be encoded in Base64.
     */
    @JvmName("khvxxuwhmemwxmqv")
    public suspend fun plaintext(`value`: Output<String>) {
        this.plaintext = value
    }

    /**
     * @param value The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("xesxiowdqoqgrqlx")
    public suspend fun encryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionContext = mapped
    }

    /**
     * @param values The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("bsmkqkrbqxcdcxmq")
    public fun encryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionContext = mapped
    }

    /**
     * @param value The globally unique ID of the CMK.
     */
    @JvmName("semsqsqkvmqqvcrm")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The plaintext to be encrypted which must be encoded in Base64.
     */
    @JvmName("xgqkratlxaqywgcv")
    public suspend fun plaintext(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plaintext = mapped
    }

    internal fun build(): CiphertextArgs = CiphertextArgs(
        encryptionContext = encryptionContext,
        keyId = keyId,
        plaintext = plaintext,
    )
}
