@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClientKey].
 */
@PulumiTagMarker
public class ClientKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClientKeyArgs = ClientKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClientKeyArgsBuilder.() -> Unit) {
        val builder = ClientKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClientKey {
        val builtJavaResource = com.pulumi.alicloud.kms.ClientKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClientKey(builtJavaResource)
    }
}

/**
 * Provides a KMS Client Key resource. Client key (of Application Access Point).
 * For information about KMS Client Key and how to use it, see [What is Client Key](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createclientkey).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const AAP0 = new alicloud.kms.ApplicationAccessPoint("AAP0", {
 *     policies: ["aa"],
 *     description: "aa",
 *     applicationAccessPointName: name,
 * });
 * const _default = new alicloud.kms.ClientKey("default", {
 *     aapName: AAP0.applicationAccessPointName,
 *     password: "YouPassword123!",
 *     notBefore: "2023-09-01T14:11:22Z",
 *     notAfter: "2028-09-01T14:11:22Z",
 *     privateKeyDataFile: "./private_key_data_file.txt",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * aap0 = alicloud.kms.ApplicationAccessPoint("AAP0",
 *     policies=["aa"],
 *     description="aa",
 *     application_access_point_name=name)
 * default = alicloud.kms.ClientKey("default",
 *     aap_name=aap0.application_access_point_name,
 *     password="YouPassword123!",
 *     not_before="2023-09-01T14:11:22Z",
 *     not_after="2028-09-01T14:11:22Z",
 *     private_key_data_file="./private_key_data_file.txt")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var AAP0 = new AliCloud.Kms.ApplicationAccessPoint("AAP0", new()
 *     {
 *         Policies = new[]
 *         {
 *             "aa",
 *         },
 *         Description = "aa",
 *         ApplicationAccessPointName = name,
 *     });
 *     var @default = new AliCloud.Kms.ClientKey("default", new()
 *     {
 *         AapName = AAP0.ApplicationAccessPointName,
 *         Password = "YouPassword123!",
 *         NotBefore = "2023-09-01T14:11:22Z",
 *         NotAfter = "2028-09-01T14:11:22Z",
 *         PrivateKeyDataFile = "./private_key_data_file.txt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		AAP0, err := kms.NewApplicationAccessPoint(ctx, "AAP0", &kms.ApplicationAccessPointArgs{
 * 			Policies: pulumi.StringArray{
 * 				pulumi.String("aa"),
 * 			},
 * 			Description:                pulumi.String("aa"),
 * 			ApplicationAccessPointName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewClientKey(ctx, "default", &kms.ClientKeyArgs{
 * 			AapName:            AAP0.ApplicationAccessPointName,
 * 			Password:           pulumi.String("YouPassword123!"),
 * 			NotBefore:          pulumi.String("2023-09-01T14:11:22Z"),
 * 			NotAfter:           pulumi.String("2028-09-01T14:11:22Z"),
 * 			PrivateKeyDataFile: pulumi.String("./private_key_data_file.txt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.ApplicationAccessPoint;
 * import com.pulumi.alicloud.kms.ApplicationAccessPointArgs;
 * import com.pulumi.alicloud.kms.ClientKey;
 * import com.pulumi.alicloud.kms.ClientKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var aAP0 = new ApplicationAccessPoint("AAP0", ApplicationAccessPointArgs.builder()
 *             .policies("aa")
 *             .description("aa")
 *             .applicationAccessPointName(name)
 *             .build());
 *         var default_ = new ClientKey("default", ClientKeyArgs.builder()
 *             .aapName(AAP0.applicationAccessPointName())
 *             .password("YouPassword123!")
 *             .notBefore("2023-09-01T14:11:22Z")
 *             .notAfter("2028-09-01T14:11:22Z")
 *             .privateKeyDataFile("./private_key_data_file.txt")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   AAP0:
 *     type: alicloud:kms:ApplicationAccessPoint
 *     properties:
 *       policies:
 *         - aa
 *       description: aa
 *       applicationAccessPointName: ${name}
 *   default:
 *     type: alicloud:kms:ClientKey
 *     properties:
 *       aapName: ${AAP0.applicationAccessPointName}
 *       password: YouPassword123!
 *       notBefore: 2023-09-01T14:11:22Z
 *       notAfter: 2028-09-01T14:11:22Z
 *       privateKeyDataFile: ./private_key_data_file.txt
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Client Key can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/clientKey:ClientKey example <id>
 * ```
 * Resource attributes such as `password`, `private_key_data_file` are not available for imported resources as this information cannot be read from the KMS API.
 */
public class ClientKey internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.ClientKey,
) : KotlinCustomResource(javaResource, ClientKeyMapper) {
    /**
     * ClientKey's parent Application Access Point name.
     */
    public val aapName: Output<String>
        get() = javaResource.aapName().applyValue({ args0 -> args0 })

    /**
     * Create timestamp, e.g. "2022-08-10T08:03:30Z".
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The ClientKey expiration time. Example: "2027-08-10 T08:03:30Z".
     */
    public val notAfter: Output<String>?
        get() = javaResource.notAfter().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The valid start time of the ClientKey. Example: "2022-08-10 T08:03:30Z".
     */
    public val notBefore: Output<String>?
        get() = javaResource.notBefore().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * To enhance security, set a password for the downloaded Client Key,When an application accesses KMS, you must use the ClientKey content and this password to initialize the SDK client.
     */
    public val password: Output<String>
        get() = javaResource.password().applyValue({ args0 -> args0 })

    /**
     * The name of file that can save access key id and access key secret. Strongly suggest you to specified it when you creating access key, otherwise, you wouldn't get its secret ever.
     */
    public val privateKeyDataFile: Output<String>?
        get() = javaResource.privateKeyDataFile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ClientKeyMapper : ResourceMapper<ClientKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.ClientKey::class == javaResource::class

    override fun map(javaResource: Resource): ClientKey = ClientKey(
        javaResource as
            com.pulumi.alicloud.kms.ClientKey,
    )
}

/**
 * @see [ClientKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClientKey].
 */
public suspend fun clientKey(name: String, block: suspend ClientKeyResourceBuilder.() -> Unit): ClientKey {
    val builder = ClientKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClientKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clientKey(name: String): ClientKey {
    val builder = ClientKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
