@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.kotlin.outputs.InstanceBindVpc
import com.pulumi.alicloud.kms.kotlin.outputs.InstanceBindVpc.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Instance].
 */
@PulumiTagMarker
public class InstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceArgs = InstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceArgsBuilder.() -> Unit) {
        val builder = InstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Instance {
        val builtJavaResource = com.pulumi.alicloud.kms.Instance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Instance(builtJavaResource)
    }
}

/**
 * Provides a KMS Instance resource.
 * For information about KMS Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/zh/key-management-service/latest/kms-instance-management).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultGetSwitches = _default.then(_default => alicloud.vpc.getSwitches({
 *     vpcId: _default.ids?.[0],
 *     zoneId: "cn-hangzhou-h",
 * }));
 * const defaultInstance = new alicloud.kms.Instance("default", {
 *     productVersion: "3",
 *     vpcId: _default.then(_default => _default.ids?.[0]),
 *     zoneIds: [
 *         "cn-hangzhou-h",
 *         "cn-hangzhou-g",
 *     ],
 *     vswitchIds: [defaultGetSwitches&#46;then(defaultGetSwitches => defaultGetSwitches&#46;ids?&#46;[0])],
 *     vpcNum: 1,
 *     keyNum: 1000,
 *     secretNum: 0,
 *     spec: 1000,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="172.16.0.0/16")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0],
 *     zone_id="cn-hangzhou-h")
 * default_instance = alicloud.kms.Instance("default",
 *     product_version="3",
 *     vpc_id=default.ids[0],
 *     zone_ids=[
 *         "cn-hangzhou-h",
 *         "cn-hangzhou-g",
 *     ],
 *     vswitch_ids=[default_get_switches&#46;ids[0]],
 *     vpc_num=1,
 *     key_num=1000,
 *     secret_num=0,
 *     spec=1000)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = @default.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = "cn-hangzhou-h",
 *     });
 *     var defaultInstance = new AliCloud.Kms.Instance("default", new()
 *     {
 *         ProductVersion = "3",
 *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
 *         ZoneIds = new[]
 *         {
 *             "cn-hangzhou-h",
 *             "cn-hangzhou-g",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         },
 *         VpcNum = 1,
 *         KeyNum = 1000,
 *         SecretNum = 0,
 *         Spec = 1000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("172.16.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(_default.Ids[0]),
 * 			ZoneId: pulumi.StringRef("cn-hangzhou-h"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewInstance(ctx, "default", &kms.InstanceArgs{
 * 			ProductVersion: pulumi.String("3"),
 * 			VpcId:          pulumi.String(_default.Ids[0]),
 * 			ZoneIds: pulumi.StringArray{
 * 				pulumi.String("cn-hangzhou-h"),
 * 				pulumi.String("cn-hangzhou-g"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetSwitches.Ids[0]),
 * 			},
 * 			VpcNum:    pulumi.Int(1),
 * 			KeyNum:    pulumi.Int(1000),
 * 			SecretNum: pulumi.Int(0),
 * 			Spec:      pulumi.Int(1000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.kms.Instance;
 * import com.pulumi.alicloud.kms.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(default_.ids()[0])
 *             .zoneId("cn-hangzhou-h")
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .productVersion("3")
 *             .vpcId(default_.ids()[0])
 *             .zoneIds(
 *                 "cn-hangzhou-h",
 *                 "cn-hangzhou-g")
 *             .vswitchIds(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpcNum("1")
 *             .keyNum("1000")
 *             .secretNum("0")
 *             .spec("1000")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:kms:Instance
 *     name: default
 *     properties:
 *       productVersion: '3'
 *       vpcId: ${default.ids[0]}
 *       zoneIds:
 *         - cn-hangzhou-h
 *         - cn-hangzhou-g
 *       vswitchIds:
 *         - ${defaultGetSwitches.ids[0]}
 *       vpcNum: '1'
 *       keyNum: '1000'
 *       secretNum: '0'
 *       spec: '1000'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 172.16.0.0/16
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${default.ids[0]}
 *         zoneId: cn-hangzhou-h
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/instance:Instance example <id>
 * ```
 */
public class Instance internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.Instance,
) : KotlinCustomResource(javaResource, InstanceMapper) {
    /**
     * Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    public val bindVpcs: Output<List<InstanceBindVpc>>?
        get() = javaResource.bindVpcs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * KMS instance certificate chain in PEM format.
     */
    public val caCertificateChainPem: Output<String>
        get() = javaResource.caCertificateChainPem().applyValue({ args0 -> args0 })

    /**
     * The creation time of the resource.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * Whether to force deletion even without backup.
     */
    public val forceDeleteWithoutBackup: Output<String>?
        get() = javaResource.forceDeleteWithoutBackup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val keyNum: Output<Int>?
        get() = javaResource.keyNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val log: Output<String>
        get() = javaResource.log().applyValue({ args0 -> args0 })

    /**
     * Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val logStorage: Output<Int>
        get() = javaResource.logStorage().applyValue({ args0 -> args0 })

    /**
     * Payment type, valid values:  `Subscription`: Prepaid. `PayAsYouGo`: Postpaid, available since v1.223.2.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * KMS Instance commodity type (software/hardware).
     */
    public val productVersion: Output<String>?
        get() = javaResource.productVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val renewStatus: Output<String>?
        get() = javaResource.renewStatus().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val secretNum: Output<Int>?
        get() = javaResource.secretNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val spec: Output<Int>?
        get() = javaResource.spec().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Instance status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Instance VPC id.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    public val vpcNum: Output<Int>?
        get() = javaResource.vpcNum().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Instance bind vswitches.
     */
    public val vswitchIds: Output<List<String>>
        get() = javaResource.vswitchIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * zone id.
     */
    public val zoneIds: Output<List<String>>
        get() = javaResource.zoneIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object InstanceMapper : ResourceMapper<Instance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.Instance::class == javaResource::class

    override fun map(javaResource: Resource): Instance = Instance(
        javaResource as
            com.pulumi.alicloud.kms.Instance,
    )
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Instance].
 */
public suspend fun instance(name: String, block: suspend InstanceResourceBuilder.() -> Unit): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Instance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instance(name: String): Instance {
    val builder = InstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
