@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.InstanceArgs.builder
import com.pulumi.alicloud.kms.kotlin.inputs.InstanceBindVpcArgs
import com.pulumi.alicloud.kms.kotlin.inputs.InstanceBindVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a KMS Instance resource.
 * For information about KMS Instance and how to use it, see [What is Instance](https://www.alibabacloud.com/help/zh/key-management-service/latest/kms-instance-management).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const default = alicloud.vpc.getNetworks({
 *     nameRegex: "^default-NODELETING$",
 *     cidrBlock: "172.16.0.0/16",
 * });
 * const defaultGetSwitches = _default.then(_default => alicloud.vpc.getSwitches({
 *     vpcId: _default.ids?.[0],
 *     zoneId: "cn-hangzhou-h",
 * }));
 * const defaultInstance = new alicloud.kms.Instance("default", {
 *     productVersion: "3",
 *     vpcId: _default.then(_default => _default.ids?.[0]),
 *     zoneIds: [
 *         "cn-hangzhou-h",
 *         "cn-hangzhou-g",
 *     ],
 *     vswitchIds: [defaultGetSwitches&#46;then(defaultGetSwitches => defaultGetSwitches&#46;ids?&#46;[0])],
 *     vpcNum: 1,
 *     keyNum: 1000,
 *     secretNum: 0,
 *     spec: 1000,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.get_networks(name_regex="^default-NODELETING$",
 *     cidr_block="172.16.0.0/16")
 * default_get_switches = alicloud.vpc.get_switches(vpc_id=default.ids[0],
 *     zone_id="cn-hangzhou-h")
 * default_instance = alicloud.kms.Instance("default",
 *     product_version="3",
 *     vpc_id=default.ids[0],
 *     zone_ids=[
 *         "cn-hangzhou-h",
 *         "cn-hangzhou-g",
 *     ],
 *     vswitch_ids=[default_get_switches&#46;ids[0]],
 *     vpc_num=1,
 *     key_num=1000,
 *     secret_num=0,
 *     spec=1000)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = AliCloud.Vpc.GetNetworks.Invoke(new()
 *     {
 *         NameRegex = "^default-NODELETING$",
 *         CidrBlock = "172.16.0.0/16",
 *     });
 *     var defaultGetSwitches = AliCloud.Vpc.GetSwitches.Invoke(new()
 *     {
 *         VpcId = @default.Apply(getNetworksResult => getNetworksResult.Ids[0]),
 *         ZoneId = "cn-hangzhou-h",
 *     });
 *     var defaultInstance = new AliCloud.Kms.Instance("default", new()
 *     {
 *         ProductVersion = "3",
 *         VpcId = @default.Apply(@default => @default.Apply(getNetworksResult => getNetworksResult.Ids[0])),
 *         ZoneIds = new[]
 *         {
 *             "cn-hangzhou-h",
 *             "cn-hangzhou-g",
 *         },
 *         VswitchIds = new[]
 *         {
 *             defaultGetSwitches.Apply(getSwitchesResult => getSwitchesResult.Ids[0]),
 *         },
 *         VpcNum = 1,
 *         KeyNum = 1000,
 *         SecretNum = 0,
 *         Spec = 1000,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_default, err := vpc.GetNetworks(ctx, &vpc.GetNetworksArgs{
 * 			NameRegex: pulumi.StringRef("^default-NODELETING$"),
 * 			CidrBlock: pulumi.StringRef("172.16.0.0/16"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetSwitches, err := vpc.GetSwitches(ctx, &vpc.GetSwitchesArgs{
 * 			VpcId:  pulumi.StringRef(_default.Ids[0]),
 * 			ZoneId: pulumi.StringRef("cn-hangzhou-h"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewInstance(ctx, "default", &kms.InstanceArgs{
 * 			ProductVersion: pulumi.String("3"),
 * 			VpcId:          pulumi.String(_default.Ids[0]),
 * 			ZoneIds: pulumi.StringArray{
 * 				pulumi.String("cn-hangzhou-h"),
 * 				pulumi.String("cn-hangzhou-g"),
 * 			},
 * 			VswitchIds: pulumi.StringArray{
 * 				pulumi.String(defaultGetSwitches.Ids[0]),
 * 			},
 * 			VpcNum:    pulumi.Int(1),
 * 			KeyNum:    pulumi.Int(1000),
 * 			SecretNum: pulumi.Int(0),
 * 			Spec:      pulumi.Int(1000),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.VpcFunctions;
 * import com.pulumi.alicloud.vpc.inputs.GetNetworksArgs;
 * import com.pulumi.alicloud.vpc.inputs.GetSwitchesArgs;
 * import com.pulumi.alicloud.kms.Instance;
 * import com.pulumi.alicloud.kms.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         final var default = VpcFunctions.getNetworks(GetNetworksArgs.builder()
 *             .nameRegex("^default-NODELETING$")
 *             .cidrBlock("172.16.0.0/16")
 *             .build());
 *         final var defaultGetSwitches = VpcFunctions.getSwitches(GetSwitchesArgs.builder()
 *             .vpcId(default_.ids()[0])
 *             .zoneId("cn-hangzhou-h")
 *             .build());
 *         var defaultInstance = new Instance("defaultInstance", InstanceArgs.builder()
 *             .productVersion("3")
 *             .vpcId(default_.ids()[0])
 *             .zoneIds(
 *                 "cn-hangzhou-h",
 *                 "cn-hangzhou-g")
 *             .vswitchIds(defaultGetSwitches.applyValue(getSwitchesResult -> getSwitchesResult.ids()[0]))
 *             .vpcNum("1")
 *             .keyNum("1000")
 *             .secretNum("0")
 *             .spec("1000")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   defaultInstance:
 *     type: alicloud:kms:Instance
 *     name: default
 *     properties:
 *       productVersion: '3'
 *       vpcId: ${default.ids[0]}
 *       zoneIds:
 *         - cn-hangzhou-h
 *         - cn-hangzhou-g
 *       vswitchIds:
 *         - ${defaultGetSwitches.ids[0]}
 *       vpcNum: '1'
 *       keyNum: '1000'
 *       secretNum: '0'
 *       spec: '1000'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:vpc:getNetworks
 *       Arguments:
 *         nameRegex: ^default-NODELETING$
 *         cidrBlock: 172.16.0.0/16
 *   defaultGetSwitches:
 *     fn::invoke:
 *       Function: alicloud:vpc:getSwitches
 *       Arguments:
 *         vpcId: ${default.ids[0]}
 *         zoneId: cn-hangzhou-h
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/instance:Instance example <id>
 * ```
 * @property bindVpcs Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
 * @property forceDeleteWithoutBackup Whether to force deletion even without backup.
 * @property keyNum Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property log Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property logStorage Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property paymentType Payment type, valid values:  `Subscription`: Prepaid. `PayAsYouGo`: Postpaid, available since v1.223.2.
 * @property period Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property productVersion KMS Instance commodity type (software/hardware).
 * @property renewPeriod Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property renewStatus Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property secretNum Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property spec The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property vpcId Instance VPC id.
 * @property vpcNum The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
 * @property vswitchIds Instance bind vswitches.
 * @property zoneIds zone id.
 */
public data class InstanceArgs(
    public val bindVpcs: Output<List<InstanceBindVpcArgs>>? = null,
    public val forceDeleteWithoutBackup: Output<String>? = null,
    public val keyNum: Output<Int>? = null,
    public val log: Output<String>? = null,
    public val logStorage: Output<Int>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val productVersion: Output<String>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewStatus: Output<String>? = null,
    public val secretNum: Output<Int>? = null,
    public val spec: Output<Int>? = null,
    public val vpcId: Output<String>? = null,
    public val vpcNum: Output<Int>? = null,
    public val vswitchIds: Output<List<String>>? = null,
    public val zoneIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.InstanceArgs =
        com.pulumi.alicloud.kms.InstanceArgs.builder()
            .bindVpcs(
                bindVpcs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .forceDeleteWithoutBackup(forceDeleteWithoutBackup?.applyValue({ args0 -> args0 }))
            .keyNum(keyNum?.applyValue({ args0 -> args0 }))
            .log(log?.applyValue({ args0 -> args0 }))
            .logStorage(logStorage?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .productVersion(productVersion?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewStatus(renewStatus?.applyValue({ args0 -> args0 }))
            .secretNum(secretNum?.applyValue({ args0 -> args0 }))
            .spec(spec?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vpcNum(vpcNum?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .zoneIds(zoneIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var bindVpcs: Output<List<InstanceBindVpcArgs>>? = null

    private var forceDeleteWithoutBackup: Output<String>? = null

    private var keyNum: Output<Int>? = null

    private var log: Output<String>? = null

    private var logStorage: Output<Int>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var productVersion: Output<String>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewStatus: Output<String>? = null

    private var secretNum: Output<Int>? = null

    private var spec: Output<Int>? = null

    private var vpcId: Output<String>? = null

    private var vpcNum: Output<Int>? = null

    private var vswitchIds: Output<List<String>>? = null

    private var zoneIds: Output<List<String>>? = null

    /**
     * @param value Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("xhyiudaltbpmytnx")
    public suspend fun bindVpcs(`value`: Output<List<InstanceBindVpcArgs>>) {
        this.bindVpcs = value
    }

    @JvmName("ikspqkilvwwrnkhh")
    public suspend fun bindVpcs(vararg values: Output<InstanceBindVpcArgs>) {
        this.bindVpcs = Output.all(values.asList())
    }

    /**
     * @param values Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("hkcgaeikstgsjcch")
    public suspend fun bindVpcs(values: List<Output<InstanceBindVpcArgs>>) {
        this.bindVpcs = Output.all(values)
    }

    /**
     * @param value Whether to force deletion even without backup.
     */
    @JvmName("bkpticmrhxkdxrbc")
    public suspend fun forceDeleteWithoutBackup(`value`: Output<String>) {
        this.forceDeleteWithoutBackup = value
    }

    /**
     * @param value Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("ntxijwsqeqvaptmw")
    public suspend fun keyNum(`value`: Output<Int>) {
        this.keyNum = value
    }

    /**
     * @param value Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("bcowpomlpyaitfnm")
    public suspend fun log(`value`: Output<String>) {
        this.log = value
    }

    /**
     * @param value Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("bfpelnqmxsypyrxg")
    public suspend fun logStorage(`value`: Output<Int>) {
        this.logStorage = value
    }

    /**
     * @param value Payment type, valid values:  `Subscription`: Prepaid. `PayAsYouGo`: Postpaid, available since v1.223.2.
     */
    @JvmName("itlruhmmmfwqkuuh")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("ojmhwmtjiwwewrex")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value KMS Instance commodity type (software/hardware).
     */
    @JvmName("oncgawaluaudafmb")
    public suspend fun productVersion(`value`: Output<String>) {
        this.productVersion = value
    }

    /**
     * @param value Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("bduvyxgtuaofagsx")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("jvltkddbvkklmuss")
    public suspend fun renewStatus(`value`: Output<String>) {
        this.renewStatus = value
    }

    /**
     * @param value Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("wnhmlgtveywbmygx")
    public suspend fun secretNum(`value`: Output<Int>) {
        this.secretNum = value
    }

    /**
     * @param value The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("xaodhfhmbxwkqdwr")
    public suspend fun spec(`value`: Output<Int>) {
        this.spec = value
    }

    /**
     * @param value Instance VPC id.
     */
    @JvmName("nnxvjwbbwirivddc")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("aixtfgsxdulgipxv")
    public suspend fun vpcNum(`value`: Output<Int>) {
        this.vpcNum = value
    }

    /**
     * @param value Instance bind vswitches.
     */
    @JvmName("wgemlatfbtkkqtah")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("erqottnfpokgmnlv")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values Instance bind vswitches.
     */
    @JvmName("qnfvptmigmoinwel")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value zone id.
     */
    @JvmName("ruoeljftdoypcypi")
    public suspend fun zoneIds(`value`: Output<List<String>>) {
        this.zoneIds = value
    }

    @JvmName("nytrxobwxvcyvuit")
    public suspend fun zoneIds(vararg values: Output<String>) {
        this.zoneIds = Output.all(values.asList())
    }

    /**
     * @param values zone id.
     */
    @JvmName("lagwsgfpaqqajwbj")
    public suspend fun zoneIds(values: List<Output<String>>) {
        this.zoneIds = Output.all(values)
    }

    /**
     * @param value Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("joquasgslnuposvm")
    public suspend fun bindVpcs(`value`: List<InstanceBindVpcArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bindVpcs = mapped
    }

    /**
     * @param argument Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("eulssrmsasydwshb")
    public suspend fun bindVpcs(argument: List<suspend InstanceBindVpcArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceBindVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bindVpcs = mapped
    }

    /**
     * @param argument Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("lrowvtijqmnlyomn")
    public suspend fun bindVpcs(vararg argument: suspend InstanceBindVpcArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceBindVpcArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.bindVpcs = mapped
    }

    /**
     * @param argument Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("wxjfhnuggdacjvxw")
    public suspend fun bindVpcs(argument: suspend InstanceBindVpcArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InstanceBindVpcArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bindVpcs = mapped
    }

    /**
     * @param values Aucillary VPCs used to access this KMS instance. See `bind_vpcs` below.
     */
    @JvmName("ohjjpcnnaebwedwj")
    public suspend fun bindVpcs(vararg values: InstanceBindVpcArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bindVpcs = mapped
    }

    /**
     * @param value Whether to force deletion even without backup.
     */
    @JvmName("hmsmxfqbualxtoyp")
    public suspend fun forceDeleteWithoutBackup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDeleteWithoutBackup = mapped
    }

    /**
     * @param value Maximum number of stored keys. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("ostilyeohnnxjqtw")
    public suspend fun keyNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyNum = mapped
    }

    /**
     * @param value Instance Audit Log Switch. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("pwudrjgcwgohlmhe")
    public suspend fun log(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.log = mapped
    }

    /**
     * @param value Instance log capacity. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("snjurigyjbuslmrp")
    public suspend fun logStorage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorage = mapped
    }

    /**
     * @param value Payment type, valid values:  `Subscription`: Prepaid. `PayAsYouGo`: Postpaid, available since v1.223.2.
     */
    @JvmName("meyhhapcvwblxyte")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Purchase cycle, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("ruoqaujbaljiickb")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value KMS Instance commodity type (software/hardware).
     */
    @JvmName("csifwowdgsvujrkb")
    public suspend fun productVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productVersion = mapped
    }

    /**
     * @param value Automatic renewal period, in months. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("aoqadsavcobjxqoe")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Renewal options. Valid values: `AutoRenewal`, `ManualRenewal`. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("bgabljisgnnmxyje")
    public suspend fun renewStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewStatus = mapped
    }

    /**
     * @param value Maximum number of Secrets. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("hiplmsqtlllwpunp")
    public suspend fun secretNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretNum = mapped
    }

    /**
     * @param value The computation performance level of the KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("mdbdidsmhqwwdvqe")
    public suspend fun spec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param value Instance VPC id.
     */
    @JvmName("qknsksxjvrrmclru")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The number of managed accesses. The maximum number of VPCs that can access this KMS instance. The attribute is valid when the attribute `payment_type` is `Subscription`.
     */
    @JvmName("ljysnlllvvppcmxd")
    public suspend fun vpcNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcNum = mapped
    }

    /**
     * @param value Instance bind vswitches.
     */
    @JvmName("pyhvnoniextmflib")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values Instance bind vswitches.
     */
    @JvmName("qwjigcjnjuveprfo")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param value zone id.
     */
    @JvmName("osdelhlltqhmpaed")
    public suspend fun zoneIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneIds = mapped
    }

    /**
     * @param values zone id.
     */
    @JvmName("iixmurycmsdsxtbx")
    public suspend fun zoneIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneIds = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        bindVpcs = bindVpcs,
        forceDeleteWithoutBackup = forceDeleteWithoutBackup,
        keyNum = keyNum,
        log = log,
        logStorage = logStorage,
        paymentType = paymentType,
        period = period,
        productVersion = productVersion,
        renewPeriod = renewPeriod,
        renewStatus = renewStatus,
        secretNum = secretNum,
        spec = spec,
        vpcId = vpcId,
        vpcNum = vpcNum,
        vswitchIds = vswitchIds,
        zoneIds = zoneIds,
    )
}
