@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Key].
 */
@PulumiTagMarker
public class KeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyArgs = KeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyArgsBuilder.() -> Unit) {
        val builder = KeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Key {
        val builtJavaResource = com.pulumi.alicloud.kms.Key(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Key(builtJavaResource)
    }
}

/**
 * Provides a KMS Key resource.
 * For information about KMS Key and how to use it, see [What is Key](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createkey).
 * > **NOTE:** Available since v1.85.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.kms.Key("default", {
 *     description: "Hello KMS",
 *     status: "Enabled",
 *     pendingWindowInDays: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.kms.Key("default",
 *     description="Hello KMS",
 *     status="Enabled",
 *     pending_window_in_days=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Kms.Key("default", new()
 *     {
 *         Description = "Hello KMS",
 *         Status = "Enabled",
 *         PendingWindowInDays = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kms.NewKey(ctx, "default", &kms.KeyArgs{
 * 			Description:         pulumi.String("Hello KMS"),
 * 			Status:              pulumi.String("Enabled"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Key("default", KeyArgs.builder()
 *             .description("Hello KMS")
 *             .status("Enabled")
 *             .pendingWindowInDays("7")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:kms:Key
 *     properties:
 *       description: Hello KMS
 *       status: Enabled
 *       pendingWindowInDays: '7'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Key can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/key:Key example <id>
 * ```
 */
public class Key internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.Key,
) : KotlinCustomResource(javaResource, KeyMapper) {
    /**
     * The ARN of the key.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
     */
    public val automaticRotation: Output<String>
        get() = javaResource.automaticRotation().applyValue({ args0 -> args0 })

    /**
     * The time when the CMK was created.
     */
    public val creationDate: Output<String>
        get() = javaResource.creationDate().applyValue({ args0 -> args0 })

    /**
     * The creator of the CMK.
     */
    public val creator: Output<String>
        get() = javaResource.creator().applyValue({ args0 -> args0 })

    /**
     * The time at which the CMK is scheduled for deletion.
     */
    public val deleteDate: Output<String>
        get() = javaResource.deleteDate().applyValue({ args0 -> args0 })

    /**
     * Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
     */
    @Deprecated(
        message = """
  Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field
      `pending_window_in_days` instead.
  """,
    )
    public val deletionWindowInDays: Output<Int>?
        get() = javaResource.deletionWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the key.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the KMS instance.
     */
    public val dkmsInstanceId: Output<String>?
        get() = javaResource.dkmsInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
     * > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
     * > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
     * > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
     */
    @Deprecated(
        message = """
  Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state`
      instead.
  """,
    )
    public val isEnabled: Output<Boolean>
        get() = javaResource.isEnabled().applyValue({ args0 -> args0 })

    /**
     * The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
     */
    public val keySpec: Output<String>
        get() = javaResource.keySpec().applyValue({ args0 -> args0 })

    /**
     * Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
     */
    @Deprecated(
        message = """
  Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
  """,
    )
    public val keyState: Output<String>
        get() = javaResource.keyState().applyValue({ args0 -> args0 })

    /**
     * The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
     * - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
     * - `SIGN/VERIFY`: Generates or verifies a digital signature.
     */
    public val keyUsage: Output<String>
        get() = javaResource.keyUsage().applyValue({ args0 -> args0 })

    /**
     * The time when the last rotation was performed.
     */
    public val lastRotationDate: Output<String>
        get() = javaResource.lastRotationDate().applyValue({ args0 -> args0 })

    /**
     * The time when the key material expires.
     */
    public val materialExpireTime: Output<String>
        get() = javaResource.materialExpireTime().applyValue({ args0 -> args0 })

    /**
     * The time when the next rotation will be performed.
     */
    public val nextRotationDate: Output<String>
        get() = javaResource.nextRotationDate().applyValue({ args0 -> args0 })

    /**
     * The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
     */
    public val origin: Output<String>
        get() = javaResource.origin().applyValue({ args0 -> args0 })

    /**
     * The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`.
     * **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
     */
    public val pendingWindowInDays: Output<Int>?
        get() = javaResource.pendingWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * The ID of the current primary key version of the symmetric CMK.
     */
    public val primaryKeyVersion: Output<String>
        get() = javaResource.primaryKeyVersion().applyValue({ args0 -> args0 })

    /**
     * The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
     */
    public val protectionLevel: Output<String>?
        get() = javaResource.protectionLevel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval.
     * **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
     */
    public val rotationInterval: Output<String>?
        get() = javaResource.rotationInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object KeyMapper : ResourceMapper<Key> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.Key::class == javaResource::class

    override fun map(javaResource: Resource): Key = Key(javaResource as com.pulumi.alicloud.kms.Key)
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Key].
 */
public suspend fun key(name: String, block: suspend KeyResourceBuilder.() -> Unit): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Key].
 * @param name The _unique_ name of the resulting resource.
 */
public fun key(name: String): Key {
    val builder = KeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
