@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.KeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a KMS Key resource.
 * For information about KMS Key and how to use it, see [What is Key](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createkey).
 * > **NOTE:** Available since v1.85.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.kms.Key("default", {
 *     description: "Hello KMS",
 *     status: "Enabled",
 *     pendingWindowInDays: 7,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.kms.Key("default",
 *     description="Hello KMS",
 *     status="Enabled",
 *     pending_window_in_days=7)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Kms.Key("default", new()
 *     {
 *         Description = "Hello KMS",
 *         Status = "Enabled",
 *         PendingWindowInDays = 7,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kms.NewKey(ctx, "default", &kms.KeyArgs{
 * 			Description:         pulumi.String("Hello KMS"),
 * 			Status:              pulumi.String("Enabled"),
 * 			PendingWindowInDays: pulumi.Int(7),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Key("default", KeyArgs.builder()
 *             .description("Hello KMS")
 *             .status("Enabled")
 *             .pendingWindowInDays("7")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:kms:Key
 *     properties:
 *       description: Hello KMS
 *       status: Enabled
 *       pendingWindowInDays: '7'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Key can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/key:Key example <id>
 * ```
 * @property automaticRotation Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
 * @property deletionWindowInDays Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
 * @property description The description of the key.
 * @property dkmsInstanceId The ID of the KMS instance.
 * @property isEnabled Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
 * > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
 * > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
 * > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
 * @property keySpec The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
 * @property keyState Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
 * @property keyUsage The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
 * - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
 * - `SIGN/VERIFY`: Generates or verifies a digital signature.
 * @property origin The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
 * @property pendingWindowInDays The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`.
 * **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
 * @property policy The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
 * @property protectionLevel The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
 * @property rotationInterval The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval.
 * **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
 * @property status The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class KeyArgs(
    public val automaticRotation: Output<String>? = null,
    @Deprecated(
        message = """
  Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field
      `pending_window_in_days` instead.
  """,
    )
    public val deletionWindowInDays: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val dkmsInstanceId: Output<String>? = null,
    @Deprecated(
        message = """
  Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state`
      instead.
  """,
    )
    public val isEnabled: Output<Boolean>? = null,
    public val keySpec: Output<String>? = null,
    @Deprecated(
        message = """
  Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
  """,
    )
    public val keyState: Output<String>? = null,
    public val keyUsage: Output<String>? = null,
    public val origin: Output<String>? = null,
    public val pendingWindowInDays: Output<Int>? = null,
    public val policy: Output<String>? = null,
    public val protectionLevel: Output<String>? = null,
    public val rotationInterval: Output<String>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.KeyArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.KeyArgs = com.pulumi.alicloud.kms.KeyArgs.builder()
        .automaticRotation(automaticRotation?.applyValue({ args0 -> args0 }))
        .deletionWindowInDays(deletionWindowInDays?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .dkmsInstanceId(dkmsInstanceId?.applyValue({ args0 -> args0 }))
        .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
        .keySpec(keySpec?.applyValue({ args0 -> args0 }))
        .keyState(keyState?.applyValue({ args0 -> args0 }))
        .keyUsage(keyUsage?.applyValue({ args0 -> args0 }))
        .origin(origin?.applyValue({ args0 -> args0 }))
        .pendingWindowInDays(pendingWindowInDays?.applyValue({ args0 -> args0 }))
        .policy(policy?.applyValue({ args0 -> args0 }))
        .protectionLevel(protectionLevel?.applyValue({ args0 -> args0 }))
        .rotationInterval(rotationInterval?.applyValue({ args0 -> args0 }))
        .status(status?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [KeyArgs].
 */
@PulumiTagMarker
public class KeyArgsBuilder internal constructor() {
    private var automaticRotation: Output<String>? = null

    private var deletionWindowInDays: Output<Int>? = null

    private var description: Output<String>? = null

    private var dkmsInstanceId: Output<String>? = null

    private var isEnabled: Output<Boolean>? = null

    private var keySpec: Output<String>? = null

    private var keyState: Output<String>? = null

    private var keyUsage: Output<String>? = null

    private var origin: Output<String>? = null

    private var pendingWindowInDays: Output<Int>? = null

    private var policy: Output<String>? = null

    private var protectionLevel: Output<String>? = null

    private var rotationInterval: Output<String>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("mwevmmlpiujnbbcp")
    public suspend fun automaticRotation(`value`: Output<String>) {
        this.automaticRotation = value
    }

    /**
     * @param value Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
     */
    @Deprecated(
        message = """
  Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field
      `pending_window_in_days` instead.
  """,
    )
    @JvmName("ljmjjoiimwrbsqht")
    public suspend fun deletionWindowInDays(`value`: Output<Int>) {
        this.deletionWindowInDays = value
    }

    /**
     * @param value The description of the key.
     */
    @JvmName("awcaoegkvfttiecu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the KMS instance.
     */
    @JvmName("ietbggvvpehmynvc")
    public suspend fun dkmsInstanceId(`value`: Output<String>) {
        this.dkmsInstanceId = value
    }

    /**
     * @param value Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
     * > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
     * > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
     * > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
     */
    @Deprecated(
        message = """
  Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state`
      instead.
  """,
    )
    @JvmName("nqkkewcutdofptkx")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
     */
    @JvmName("xjsjruqjaktiwvwn")
    public suspend fun keySpec(`value`: Output<String>) {
        this.keySpec = value
    }

    /**
     * @param value Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
     */
    @Deprecated(
        message = """
  Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
  """,
    )
    @JvmName("yejjdmaaqxrwlakl")
    public suspend fun keyState(`value`: Output<String>) {
        this.keyState = value
    }

    /**
     * @param value The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
     * - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
     * - `SIGN/VERIFY`: Generates or verifies a digital signature.
     */
    @JvmName("nhycgudqsebehopo")
    public suspend fun keyUsage(`value`: Output<String>) {
        this.keyUsage = value
    }

    /**
     * @param value The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
     */
    @JvmName("cchkwdvgweeexuox")
    public suspend fun origin(`value`: Output<String>) {
        this.origin = value
    }

    /**
     * @param value The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`.
     * **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
     */
    @JvmName("xbrtdhargbegbwpk")
    public suspend fun pendingWindowInDays(`value`: Output<Int>) {
        this.pendingWindowInDays = value
    }

    /**
     * @param value The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
     */
    @JvmName("rinhdsrbmoqrbmxb")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
     */
    @JvmName("kxjrjfgcxyrabxmn")
    public suspend fun protectionLevel(`value`: Output<String>) {
        this.protectionLevel = value
    }

    /**
     * @param value The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval.
     * **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
     */
    @JvmName("ewxrsulqjqjrgnqp")
    public suspend fun rotationInterval(`value`: Output<String>) {
        this.rotationInterval = value
    }

    /**
     * @param value The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
     */
    @JvmName("svlvsukqkfbcdpdh")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("xmbubivklnvswpfo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether to enable automatic key rotation. Default value: `Disabled`. Valid values: `Enabled`, `Disabled`.
     */
    @JvmName("uoeiujstmsqxirux")
    public suspend fun automaticRotation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticRotation = mapped
    }

    /**
     * @param value Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field `pending_window_in_days` instead.
     */
    @Deprecated(
        message = """
  Field `deletion_window_in_days` has been deprecated from provider version 1.85.0. New field
      `pending_window_in_days` instead.
  """,
    )
    @JvmName("tdkoxbqwpbdwxyyn")
    public suspend fun deletionWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionWindowInDays = mapped
    }

    /**
     * @param value The description of the key.
     */
    @JvmName("esvrpbixcnvrcfet")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the KMS instance.
     */
    @JvmName("pauuebuhyfemrovo")
    public suspend fun dkmsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dkmsInstanceId = mapped
    }

    /**
     * @param value Field `is_enabled` has been deprecated from provider version 1.85.0. New field `status` instead.
     * > **NOTE:** If you set the origin parameter to EXTERNAL or the key_spec parameter to an asymmetric CMK type, automatic key rotation is unavailable.
     * > **NOTE:** The default type of the CMK is `Aliyun_AES_256`. Only Dedicated KMS supports `Aliyun_AES_128` and `Aliyun_AES_192`.
     * > **NOTE:** When the pre-deletion days elapses, the key is permanently deleted and cannot be recovered.
     */
    @Deprecated(
        message = """
  Field `is_enabled` has been deprecated from provider version 1.85.0. New field `key_state`
      instead.
  """,
    )
    @JvmName("ffyrojmeufhqvcrh")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The specification of the key. Default value: `Aliyun_AES_256`. Valid values: `Aliyun_AES_256`, `Aliyun_AES_128`, `Aliyun_AES_192`, `Aliyun_SM4`, `RSA_2048`, `RSA_3072`, `EC_P256`, `EC_P256K`, `EC_SM2`.
     */
    @JvmName("otvtkcbyeiqtbjnf")
    public suspend fun keySpec(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySpec = mapped
    }

    /**
     * @param value Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
     */
    @Deprecated(
        message = """
  Field `key_state` has been deprecated from provider version 1.123.1. New field `status` instead.
  """,
    )
    @JvmName("unqqlrxrhwcfgarm")
    public suspend fun keyState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyState = mapped
    }

    /**
     * @param value The usage of the key. Default value: `ENCRYPT/DECRYPT`. Valid values:
     * - `ENCRYPT/DECRYPT`: Encrypts or decrypts data.
     * - `SIGN/VERIFY`: Generates or verifies a digital signature.
     */
    @JvmName("ipiektwkcnpcrsxe")
    public suspend fun keyUsage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyUsage = mapped
    }

    /**
     * @param value The key material origin. Default value: `Aliyun_KMS`. Valid values: `Aliyun_KMS`, `EXTERNAL`.
     */
    @JvmName("slljuvcrykkfeixd")
    public suspend fun origin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.origin = mapped
    }

    /**
     * @param value The number of days before the CMK is deleted. During this period, the CMK is in the PendingDeletion state. After this period ends, you cannot cancel the deletion. Unit: days. Valid values: `7` to `366`.
     * **NOTE:** From version 1.184.0, `pending_window_in_days` can be set to `366`.
     */
    @JvmName("dgbbevhuxgckrbai")
    public suspend fun pendingWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pendingWindowInDays = mapped
    }

    /**
     * @param value The content of the key policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setkeypolicy).
     */
    @JvmName("vhsjgolyfwwvddej")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value The protection level of the key. Default value: `SOFTWARE`. Valid values: `SOFTWARE`, `HSM`.
     */
    @JvmName("rphedwankqxecojl")
    public suspend fun protectionLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionLevel = mapped
    }

    /**
     * @param value The period of automatic key rotation. The following units are supported: d (day), h (hour), m (minute), and s (second). For example, you can use either 7d or 604800s to specify a seven-day interval.
     * **NOTE**: If `automatic_rotation` is set to `Enabled`, `rotation_interval` is required.
     */
    @JvmName("kpjxnqwqbtdcipgj")
    public suspend fun rotationInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationInterval = mapped
    }

    /**
     * @param value The status of key. Default value: `Enabled`. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
     */
    @JvmName("uxqggrvuurdorbng")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("wphhflqhhiygwgjp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("crfeijgjolcvtvjc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): KeyArgs = KeyArgs(
        automaticRotation = automaticRotation,
        deletionWindowInDays = deletionWindowInDays,
        description = description,
        dkmsInstanceId = dkmsInstanceId,
        isEnabled = isEnabled,
        keySpec = keySpec,
        keyState = keyState,
        keyUsage = keyUsage,
        origin = origin,
        pendingWindowInDays = pendingWindowInDays,
        policy = policy,
        protectionLevel = protectionLevel,
        rotationInterval = rotationInterval,
        status = status,
        tags = tags,
    )
}
