@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [KeyVersion].
 */
@PulumiTagMarker
public class KeyVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KeyVersionArgs = KeyVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KeyVersionArgsBuilder.() -> Unit) {
        val builder = KeyVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): KeyVersion {
        val builtJavaResource = com.pulumi.alicloud.kms.KeyVersion(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return KeyVersion(builtJavaResource)
    }
}

/**
 * Provides a Alikms Key Version resource. For information about Alikms Key Version and how to use it, see [What is Resource Alikms Key Version](https://www.alibabacloud.com/help/doc-detail/133838.htm).
 * > **NOTE:** Available in v1.85.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _this = new alicloud.kms.Key("this", {});
 * const keyversion = new alicloud.kms.KeyVersion("keyversion", {keyId: _this.id});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * this = alicloud.kms.Key("this")
 * keyversion = alicloud.kms.KeyVersion("keyversion", key_id=this.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new AliCloud.Kms.Key("this");
 *     var keyversion = new AliCloud.Kms.KeyVersion("keyversion", new()
 *     {
 *         KeyId = @this.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		this, err := kms.NewKey(ctx, "this", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = kms.NewKeyVersion(ctx, "keyversion", &kms.KeyVersionArgs{
 * 			KeyId: this.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Key;
 * import com.pulumi.alicloud.kms.KeyVersion;
 * import com.pulumi.alicloud.kms.KeyVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Key("this");
 *         var keyversion = new KeyVersion("keyversion", KeyVersionArgs.builder()
 *             .keyId(this_.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: alicloud:kms:Key
 *   keyversion:
 *     type: alicloud:kms:KeyVersion
 *     properties:
 *       keyId: ${this.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alikms key version can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/keyVersion:KeyVersion example 72da539a-2fa8-4f2d-b854-*****
 * ```
 */
public class KeyVersion internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.KeyVersion,
) : KotlinCustomResource(javaResource, KeyVersionMapper) {
    /**
     * The id of the master key (CMK).
     * > **NOTE:** The minimum interval for creating a Alikms key version is 7 days.
     */
    public val keyId: Output<String>
        get() = javaResource.keyId().applyValue({ args0 -> args0 })

    /**
     * The id of the Alikms key version.
     */
    public val keyVersionId: Output<String>
        get() = javaResource.keyVersionId().applyValue({ args0 -> args0 })
}

public object KeyVersionMapper : ResourceMapper<KeyVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.KeyVersion::class == javaResource::class

    override fun map(javaResource: Resource): KeyVersion = KeyVersion(
        javaResource as
            com.pulumi.alicloud.kms.KeyVersion,
    )
}

/**
 * @see [KeyVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KeyVersion].
 */
public suspend fun keyVersion(name: String, block: suspend KeyVersionResourceBuilder.() -> Unit): KeyVersion {
    val builder = KeyVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KeyVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun keyVersion(name: String): KeyVersion {
    val builder = KeyVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
