@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.KmsFunctions.getAliasesPlain
import com.pulumi.alicloud.kms.KmsFunctions.getCiphertextPlain
import com.pulumi.alicloud.kms.KmsFunctions.getKeyVersionsPlain
import com.pulumi.alicloud.kms.KmsFunctions.getKeysPlain
import com.pulumi.alicloud.kms.KmsFunctions.getPlaintextPlain
import com.pulumi.alicloud.kms.KmsFunctions.getSecretVersionsPlain
import com.pulumi.alicloud.kms.KmsFunctions.getSecretsPlain
import com.pulumi.alicloud.kms.KmsFunctions.getServicePlain
import com.pulumi.alicloud.kms.kotlin.inputs.GetAliasesPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetAliasesPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetCiphertextPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetCiphertextPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetKeyVersionsPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetKeyVersionsPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetKeysPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetKeysPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetPlaintextPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetPlaintextPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetSecretVersionsPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetSecretVersionsPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetSecretsPlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetSecretsPlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.kms.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.kms.kotlin.outputs.GetAliasesResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetCiphertextResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetKeyVersionsResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetKeysResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetPlaintextResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetSecretVersionsResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetSecretsResult
import com.pulumi.alicloud.kms.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.kms.kotlin.outputs.GetAliasesResult.Companion.toKotlin as getAliasesResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetCiphertextResult.Companion.toKotlin as getCiphertextResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetKeyVersionsResult.Companion.toKotlin as getKeyVersionsResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetKeysResult.Companion.toKotlin as getKeysResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetPlaintextResult.Companion.toKotlin as getPlaintextResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetSecretVersionsResult.Companion.toKotlin as getSecretVersionsResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetSecretsResult.Companion.toKotlin as getSecretsResultToKotlin
import com.pulumi.alicloud.kms.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object KmsFunctions {
    /**
     * This data source provides a list of KMS aliases in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.79.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const kmsAliases = alicloud.kms.getAliases({
     *     ids: ["d89e8a53-b708-41aa-8c67-6873axxx"],
     *     nameRegex: "alias/tf-testKmsAlias_123",
     * });
     * export const firstKeyId = kmsKeysDs.keys[0].id;
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * kms_aliases = alicloud.kms.get_aliases(ids=["d89e8a53-b708-41aa-8c67-6873axxx"],
     *     name_regex="alias/tf-testKmsAlias_123")
     * pulumi.export("firstKeyId", kms_keys_ds["keys"][0]["id"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var kmsAliases = AliCloud.Kms.GetAliases.Invoke(new()
     *     {
     *         Ids = new[]
     *         {
     *             "d89e8a53-b708-41aa-8c67-6873axxx",
     *         },
     *         NameRegex = "alias/tf-testKmsAlias_123",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstKeyId"] = kmsKeysDs&#46;Keys[0].Id,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		_, err := kms.GetAliases(ctx, &kms.GetAliasesArgs{
     * 			Ids: []string{
     * 				"d89e8a53-b708-41aa-8c67-6873axxx",
     * 			},
     * 			NameRegex: pulumi.StringRef("alias/tf-testKmsAlias_123"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstKeyId", kmsKeysDs.Keys[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetAliasesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var kmsAliases = KmsFunctions.getAliases(GetAliasesArgs.builder()
     *             .ids("d89e8a53-b708-41aa-8c67-6873axxx")
     *             .nameRegex("alias/tf-testKmsAlias_123")
     *             .build());
     *         ctx.export("firstKeyId", kmsKeysDs.keys()[0].id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   kmsAliases:
     *     fn::invoke:
     *       Function: alicloud:kms:getAliases
     *       Arguments:
     *         ids:
     *           - d89e8a53-b708-41aa-8c67-6873axxx
     *         nameRegex: alias/tf-testKmsAlias_123
     * outputs:
     *   firstKeyId: ${kmsKeysDs.keys[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAliases.
     * @return A collection of values returned by getAliases.
     */
    public suspend fun getAliases(argument: GetAliasesPlainArgs): GetAliasesResult =
        getAliasesResultToKotlin(getAliasesPlain(argument.toJava()).await())

    /**
     * @see [getAliases].
     * @param ids A list of KMS aliases IDs. The value is same as KMS alias_name.
     * @param nameRegex A regex string to filter the results by the KMS alias name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getAliases.
     */
    public suspend fun getAliases(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetAliasesResult {
        val argument = GetAliasesPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getAliasesResultToKotlin(getAliasesPlain(argument.toJava()).await())
    }

    /**
     * @see [getAliases].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetAliasesPlainArgs].
     * @return A collection of values returned by getAliases.
     */
    public suspend fun getAliases(argument: suspend GetAliasesPlainArgsBuilder.() -> Unit): GetAliasesResult {
        val builder = GetAliasesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAliasesResultToKotlin(getAliasesPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const key = new alicloud.kms.Key("key", {
     *     description: "example key",
     *     isEnabled: true,
     * });
     * const encrypted = alicloud.kms.getCiphertextOutput({
     *     keyId: key.id,
     *     plaintext: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * key = alicloud.kms.Key("key",
     *     description="example key",
     *     is_enabled=True)
     * encrypted = alicloud.kms.get_ciphertext_output(key_id=key.id,
     *     plaintext="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var key = new AliCloud.Kms.Key("key", new()
     *     {
     *         Description = "example key",
     *         IsEnabled = true,
     *     });
     *     var encrypted = AliCloud.Kms.GetCiphertext.Invoke(new()
     *     {
     *         KeyId = key.Id,
     *         Plaintext = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
     * 			Description: pulumi.String("example key"),
     * 			IsEnabled:   pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_ = kms.LookupCiphertextOutput(ctx, kms.GetCiphertextOutputArgs{
     * 			KeyId:     key.ID(),
     * 			Plaintext: pulumi.String("example"),
     * 		}, nil)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.Key;
     * import com.pulumi.alicloud.kms.KeyArgs;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetCiphertextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var key = new Key("key", KeyArgs.builder()
     *             .description("example key")
     *             .isEnabled(true)
     *             .build());
     *         final var encrypted = KmsFunctions.getCiphertext(GetCiphertextArgs.builder()
     *             .keyId(key.id())
     *             .plaintext("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   key:
     *     type: alicloud:kms:Key
     *     properties:
     *       description: example key
     *       isEnabled: true
     * variables:
     *   encrypted:
     *     fn::invoke:
     *       Function: alicloud:kms:getCiphertext
     *       Arguments:
     *         keyId: ${key.id}
     *         plaintext: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCiphertext.
     * @return A collection of values returned by getCiphertext.
     */
    public suspend fun getCiphertext(argument: GetCiphertextPlainArgs): GetCiphertextResult =
        getCiphertextResultToKotlin(getCiphertextPlain(argument.toJava()).await())

    /**
     * @see [getCiphertext].
     * @param encryptionContext The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     * @param keyId The globally unique ID of the CMK.
     * @param plaintext The plaintext to be encrypted which must be encoded in Base64.
     * @return A collection of values returned by getCiphertext.
     */
    public suspend fun getCiphertext(
        encryptionContext: Map<String, String>? = null,
        keyId: String,
        plaintext: String,
    ): GetCiphertextResult {
        val argument = GetCiphertextPlainArgs(
            encryptionContext = encryptionContext,
            keyId = keyId,
            plaintext = plaintext,
        )
        return getCiphertextResultToKotlin(getCiphertextPlain(argument.toJava()).await())
    }

    /**
     * @see [getCiphertext].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetCiphertextPlainArgs].
     * @return A collection of values returned by getCiphertext.
     */
    public suspend fun getCiphertext(argument: suspend GetCiphertextPlainArgsBuilder.() -> Unit): GetCiphertextResult {
        val builder = GetCiphertextPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCiphertextResultToKotlin(getCiphertextPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of KMS KeyVersions in an Alibaba Cloud account according to the specified filters.
     * > NOTE: Available in v1.85.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const alicloudKmsKeyVersionsDs = alicloud.kms.getKeyVersions({
     *     keyId: "08438c-b4d5-4d05-928c-07b7xxxx",
     *     ids: ["d89e8a53-b708-41aa-8c67-6873axxx"],
     * });
     * export const allVersions = alicloudKmsKeyVersionsDs.then(alicloudKmsKeyVersionsDs => alicloudKmsKeyVersionsDs.versions);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * alicloud_kms_key_versions_ds = alicloud.kms.get_key_versions(key_id="08438c-b4d5-4d05-928c-07b7xxxx",
     *     ids=["d89e8a53-b708-41aa-8c67-6873axxx"])
     * pulumi.export("allVersions", alicloud_kms_key_versions_ds.versions)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var alicloudKmsKeyVersionsDs = AliCloud.Kms.GetKeyVersions.Invoke(new()
     *     {
     *         KeyId = "08438c-b4d5-4d05-928c-07b7xxxx",
     *         Ids = new[]
     *         {
     *             "d89e8a53-b708-41aa-8c67-6873axxx",
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["allVersions"] = alicloudKmsKeyVersionsDs.Apply(getKeyVersionsResult => getKeyVersionsResult.Versions),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		alicloudKmsKeyVersionsDs, err := kms.GetKeyVersions(ctx, &kms.GetKeyVersionsArgs{
     * 			KeyId: "08438c-b4d5-4d05-928c-07b7xxxx",
     * 			Ids: []string{
     * 				"d89e8a53-b708-41aa-8c67-6873axxx",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("allVersions", alicloudKmsKeyVersionsDs.Versions)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetKeyVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var alicloudKmsKeyVersionsDs = KmsFunctions.getKeyVersions(GetKeyVersionsArgs.builder()
     *             .keyId("08438c-b4d5-4d05-928c-07b7xxxx")
     *             .ids("d89e8a53-b708-41aa-8c67-6873axxx")
     *             .build());
     *         ctx.export("allVersions", alicloudKmsKeyVersionsDs.applyValue(getKeyVersionsResult -> getKeyVersionsResult.versions()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   alicloudKmsKeyVersionsDs:
     *     fn::invoke:
     *       Function: alicloud:kms:getKeyVersions
     *       Arguments:
     *         keyId: 08438c-b4d5-4d05-928c-07b7xxxx
     *         ids:
     *           - d89e8a53-b708-41aa-8c67-6873axxx
     * outputs:
     *   allVersions: ${alicloudKmsKeyVersionsDs.versions}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKeyVersions.
     * @return A collection of values returned by getKeyVersions.
     */
    public suspend fun getKeyVersions(argument: GetKeyVersionsPlainArgs): GetKeyVersionsResult =
        getKeyVersionsResultToKotlin(getKeyVersionsPlain(argument.toJava()).await())

    /**
     * @see [getKeyVersions].
     * @param ids A list of KMS KeyVersion IDs.
     * @param keyId The id of kms key.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getKeyVersions.
     */
    public suspend fun getKeyVersions(
        ids: List<String>? = null,
        keyId: String,
        outputFile: String? = null,
    ): GetKeyVersionsResult {
        val argument = GetKeyVersionsPlainArgs(
            ids = ids,
            keyId = keyId,
            outputFile = outputFile,
        )
        return getKeyVersionsResultToKotlin(getKeyVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeyVersions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetKeyVersionsPlainArgs].
     * @return A collection of values returned by getKeyVersions.
     */
    public suspend fun getKeyVersions(argument: suspend GetKeyVersionsPlainArgsBuilder.() -> Unit): GetKeyVersionsResult {
        val builder = GetKeyVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeyVersionsResultToKotlin(getKeyVersionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of KMS keys in an Alibaba Cloud account according to the specified filters.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const kmsKeysDs = alicloud.kms.getKeys({
     *     descriptionRegex: "Hello KMS",
     *     outputFile: "kms_keys.json",
     * });
     * export const firstKeyId = kmsKeysDs.then(kmsKeysDs => kmsKeysDs.keys?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * kms_keys_ds = alicloud.kms.get_keys(description_regex="Hello KMS",
     *     output_file="kms_keys.json")
     * pulumi.export("firstKeyId", kms_keys_ds.keys[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var kmsKeysDs = AliCloud.Kms.GetKeys.Invoke(new()
     *     {
     *         DescriptionRegex = "Hello KMS",
     *         OutputFile = "kms_keys.json",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstKeyId"] = kmsKeysDs&#46;Apply(getKeysResult => getKeysResult&#46;Keys[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		kmsKeysDs, err := kms.GetKeys(ctx, &kms.GetKeysArgs{
     * 			DescriptionRegex: pulumi.StringRef("Hello KMS"),
     * 			OutputFile:       pulumi.StringRef("kms_keys.json"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstKeyId", kmsKeysDs.Keys[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetKeysArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var kmsKeysDs = KmsFunctions.getKeys(GetKeysArgs.builder()
     *             .descriptionRegex("Hello KMS")
     *             .outputFile("kms_keys.json")
     *             .build());
     *         ctx.export("firstKeyId", kmsKeysDs.applyValue(getKeysResult -> getKeysResult.keys()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   kmsKeysDs:
     *     fn::invoke:
     *       Function: alicloud:kms:getKeys
     *       Arguments:
     *         descriptionRegex: Hello KMS
     *         outputFile: kms_keys.json
     * outputs:
     *   firstKeyId: ${kmsKeysDs.keys[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getKeys.
     * @return A collection of values returned by getKeys.
     */
    public suspend fun getKeys(argument: GetKeysPlainArgs): GetKeysResult =
        getKeysResultToKotlin(getKeysPlain(argument.toJava()).await())

    /**
     * @see [getKeys].
     * @param descriptionRegex A regex string to filter the results by the KMS key description.
     * @param enableDetails
     * @param filters The CMK filter. The filter consists of one or more key-value pairs.
     * You can specify a maximum of 10 key-value pairs. More details see API [ListKeys](https://www.alibabacloud.com/help/en/key-management-service/latest/listkeys).
     * @param ids A list of KMS key IDs.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
     * @return A collection of values returned by getKeys.
     */
    public suspend fun getKeys(
        descriptionRegex: String? = null,
        enableDetails: Boolean? = null,
        filters: String? = null,
        ids: List<String>? = null,
        outputFile: String? = null,
        status: String? = null,
    ): GetKeysResult {
        val argument = GetKeysPlainArgs(
            descriptionRegex = descriptionRegex,
            enableDetails = enableDetails,
            filters = filters,
            ids = ids,
            outputFile = outputFile,
            status = status,
        )
        return getKeysResultToKotlin(getKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getKeys].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetKeysPlainArgs].
     * @return A collection of values returned by getKeys.
     */
    public suspend fun getKeys(argument: suspend GetKeysPlainArgsBuilder.() -> Unit): GetKeysResult {
        val builder = GetKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKeysResultToKotlin(getKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const key = new alicloud.kms.Key("key", {
     *     description: "example key",
     *     isEnabled: true,
     * });
     * // Encrypt plaintext 'example'
     * const encrypted = new alicloud.kms.Ciphertext("encrypted", {
     *     keyId: key.id,
     *     plaintext: "example",
     * });
     * // Decrypt encrypted ciphertext
     * const plaintext = alicloud.kms.getPlaintextOutput({
     *     ciphertextBlob: encrypted.ciphertextBlob,
     * });
     * export const decrypted = plaintext.apply(plaintext => plaintext.plaintext);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * key = alicloud.kms.Key("key",
     *     description="example key",
     *     is_enabled=True)
     * # Encrypt plaintext 'example'
     * encrypted = alicloud.kms.Ciphertext("encrypted",
     *     key_id=key.id,
     *     plaintext="example")
     * # Decrypt encrypted ciphertext
     * plaintext = alicloud.kms.get_plaintext_output(ciphertext_blob=encrypted.ciphertext_blob)
     * pulumi.export("decrypted", plaintext.plaintext)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var key = new AliCloud.Kms.Key("key", new()
     *     {
     *         Description = "example key",
     *         IsEnabled = true,
     *     });
     *     // Encrypt plaintext 'example'
     *     var encrypted = new AliCloud.Kms.Ciphertext("encrypted", new()
     *     {
     *         KeyId = key.Id,
     *         Plaintext = "example",
     *     });
     *     // Decrypt encrypted ciphertext
     *     var plaintext = AliCloud.Kms.GetPlaintext.Invoke(new()
     *     {
     *         CiphertextBlob = encrypted.CiphertextBlob,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["decrypted"] = plaintext.Apply(getPlaintextResult => getPlaintextResult.Plaintext),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		key, err := kms.NewKey(ctx, "key", &kms.KeyArgs{
     * 			Description: pulumi.String("example key"),
     * 			IsEnabled:   pulumi.Bool(true),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Encrypt plaintext 'example'
     * 		encrypted, err := kms.NewCiphertext(ctx, "encrypted", &kms.CiphertextArgs{
     * 			KeyId:     key.ID(),
     * 			Plaintext: pulumi.String("example"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Decrypt encrypted ciphertext
     * 		plaintext := kms.GetPlaintextOutput(ctx, kms.GetPlaintextOutputArgs{
     * 			CiphertextBlob: encrypted.CiphertextBlob,
     * 		}, nil)
     * 		ctx.Export("decrypted", plaintext.ApplyT(func(plaintext kms.GetPlaintextResult) (*string, error) {
     * 			return &plaintext.Plaintext, nil
     * 		}).(pulumi.StringPtrOutput))
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.Key;
     * import com.pulumi.alicloud.kms.KeyArgs;
     * import com.pulumi.alicloud.kms.Ciphertext;
     * import com.pulumi.alicloud.kms.CiphertextArgs;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetPlaintextArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var key = new Key("key", KeyArgs.builder()
     *             .description("example key")
     *             .isEnabled(true)
     *             .build());
     *         // Encrypt plaintext 'example'
     *         var encrypted = new Ciphertext("encrypted", CiphertextArgs.builder()
     *             .keyId(key.id())
     *             .plaintext("example")
     *             .build());
     *         // Decrypt encrypted ciphertext
     *         final var plaintext = KmsFunctions.getPlaintext(GetPlaintextArgs.builder()
     *             .ciphertextBlob(encrypted.ciphertextBlob())
     *             .build());
     *         ctx.export("decrypted", plaintext.applyValue(getPlaintextResult -> getPlaintextResult).applyValue(plaintext -> plaintext.applyValue(getPlaintextResult -> getPlaintextResult.plaintext())));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   key:
     *     type: alicloud:kms:Key
     *     properties:
     *       description: example key
     *       isEnabled: true
     *   # Encrypt plaintext 'example'
     *   encrypted:
     *     type: alicloud:kms:Ciphertext
     *     properties:
     *       keyId: ${key.id}
     *       plaintext: example
     * variables:
     *   # Decrypt encrypted ciphertext
     *   plaintext:
     *     fn::invoke:
     *       Function: alicloud:kms:getPlaintext
     *       Arguments:
     *         ciphertextBlob: ${encrypted.ciphertextBlob}
     * outputs:
     *   # Output 'example' should match the plaintext encrypted in the beginning
     *   decrypted: ${plaintext.plaintext}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPlaintext.
     * @return A collection of values returned by getPlaintext.
     */
    public suspend fun getPlaintext(argument: GetPlaintextPlainArgs): GetPlaintextResult =
        getPlaintextResultToKotlin(getPlaintextPlain(argument.toJava()).await())

    /**
     * @see [getPlaintext].
     * @param ciphertextBlob The ciphertext to be decrypted.
     * @param encryptionContext (Optional) The Encryption context. If you specify this parameter in the Encrypt or GenerateDataKey API operation, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     * @return A collection of values returned by getPlaintext.
     */
    public suspend fun getPlaintext(
        ciphertextBlob: String,
        encryptionContext: Map<String, String>? =
            null,
    ): GetPlaintextResult {
        val argument = GetPlaintextPlainArgs(
            ciphertextBlob = ciphertextBlob,
            encryptionContext = encryptionContext,
        )
        return getPlaintextResultToKotlin(getPlaintextPlain(argument.toJava()).await())
    }

    /**
     * @see [getPlaintext].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetPlaintextPlainArgs].
     * @return A collection of values returned by getPlaintext.
     */
    public suspend fun getPlaintext(argument: suspend GetPlaintextPlainArgsBuilder.() -> Unit): GetPlaintextResult {
        val builder = GetPlaintextPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPlaintextResultToKotlin(getPlaintextPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of KMS Secret Versions in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.88.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const kmsSecretVersionsDs = alicloud.kms.getSecretVersions({
     *     secretName: "secret_name",
     *     enableDetails: true,
     * });
     * export const firstSecretData = kmsSecretVersionsDs.then(kmsSecretVersionsDs => kmsSecretVersionsDs.versions?.[0]?.secretData);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * kms_secret_versions_ds = alicloud.kms.get_secret_versions(secret_name="secret_name",
     *     enable_details=True)
     * pulumi.export("firstSecretData", kms_secret_versions_ds.versions[0].secret_data)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var kmsSecretVersionsDs = AliCloud.Kms.GetSecretVersions.Invoke(new()
     *     {
     *         SecretName = "secret_name",
     *         EnableDetails = true,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSecretData"] = kmsSecretVersionsDs&#46;Apply(getSecretVersionsResult => getSecretVersionsResult&#46;Versions[0]?.SecretData),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		kmsSecretVersionsDs, err := kms.GetSecretVersions(ctx, &kms.GetSecretVersionsArgs{
     * 			SecretName:    "secret_name",
     * 			EnableDetails: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSecretData", kmsSecretVersionsDs.Versions[0].SecretData)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetSecretVersionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var kmsSecretVersionsDs = KmsFunctions.getSecretVersions(GetSecretVersionsArgs.builder()
     *             .secretName("secret_name")
     *             .enableDetails(true)
     *             .build());
     *         ctx.export("firstSecretData", kmsSecretVersionsDs.applyValue(getSecretVersionsResult -> getSecretVersionsResult.versions()[0].secretData()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   kmsSecretVersionsDs:
     *     fn::invoke:
     *       Function: alicloud:kms:getSecretVersions
     *       Arguments:
     *         secretName: secret_name
     *         enableDetails: true
     * outputs:
     *   firstSecretData: ${kmsSecretVersionsDs.versions[0].secretData}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecretVersions.
     * @return A collection of values returned by getSecretVersions.
     */
    public suspend fun getSecretVersions(argument: GetSecretVersionsPlainArgs): GetSecretVersionsResult =
        getSecretVersionsResultToKotlin(getSecretVersionsPlain(argument.toJava()).await())

    /**
     * @see [getSecretVersions].
     * @param enableDetails Default to false and only output `secret_name`, `version_id`, `version_stages`. Set it to true can output more details.
     * @param ids A list of KMS Secret Version ids.
     * @param includeDeprecated Specifies whether to return deprecated secret versions. Default to `false`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param secretName The name of the secret.
     * @param versionStage The stage of the secret version.
     * @return A collection of values returned by getSecretVersions.
     */
    public suspend fun getSecretVersions(
        enableDetails: Boolean? = null,
        ids: List<String>? = null,
        includeDeprecated: String? = null,
        outputFile: String? = null,
        secretName: String,
        versionStage: String? = null,
    ): GetSecretVersionsResult {
        val argument = GetSecretVersionsPlainArgs(
            enableDetails = enableDetails,
            ids = ids,
            includeDeprecated = includeDeprecated,
            outputFile = outputFile,
            secretName = secretName,
            versionStage = versionStage,
        )
        return getSecretVersionsResultToKotlin(getSecretVersionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecretVersions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetSecretVersionsPlainArgs].
     * @return A collection of values returned by getSecretVersions.
     */
    public suspend fun getSecretVersions(argument: suspend GetSecretVersionsPlainArgsBuilder.() -> Unit): GetSecretVersionsResult {
        val builder = GetSecretVersionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretVersionsResultToKotlin(getSecretVersionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides a list of KMS Secrets in an Alibaba Cloud account according to the specified filters.
     * > **NOTE:** Available in v1.86.0+.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const kmsSecretsDs = alicloud.kms.getSecrets({
     *     fetchTags: true,
     *     nameRegex: "name_regex",
     *     tags: {
     *         "k-aa": "v-aa",
     *         "k-bb": "v-bb",
     *     },
     * });
     * export const firstSecretId = kmsSecretsDs.then(kmsSecretsDs => kmsSecretsDs.secrets?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * kms_secrets_ds = alicloud.kms.get_secrets(fetch_tags=True,
     *     name_regex="name_regex",
     *     tags={
     *         "k-aa": "v-aa",
     *         "k-bb": "v-bb",
     *     })
     * pulumi.export("firstSecretId", kms_secrets_ds.secrets[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var kmsSecretsDs = AliCloud.Kms.GetSecrets.Invoke(new()
     *     {
     *         FetchTags = true,
     *         NameRegex = "name_regex",
     *         Tags =
     *         {
     *             { "k-aa", "v-aa" },
     *             { "k-bb", "v-bb" },
     *         },
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstSecretId"] = kmsSecretsDs&#46;Apply(getSecretsResult => getSecretsResult&#46;Secrets[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		kmsSecretsDs, err := kms.GetSecrets(ctx, &kms.GetSecretsArgs{
     * 			FetchTags: pulumi.BoolRef(true),
     * 			NameRegex: pulumi.StringRef("name_regex"),
     * 			Tags: map[string]interface{}{
     * 				"k-aa": "v-aa",
     * 				"k-bb": "v-bb",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstSecretId", kmsSecretsDs.Secrets[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetSecretsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var kmsSecretsDs = KmsFunctions.getSecrets(GetSecretsArgs.builder()
     *             .fetchTags(true)
     *             .nameRegex("name_regex")
     *             .tags(Map.ofEntries(
     *                 Map.entry("k-aa", "v-aa"),
     *                 Map.entry("k-bb", "v-bb")
     *             ))
     *             .build());
     *         ctx.export("firstSecretId", kmsSecretsDs.applyValue(getSecretsResult -> getSecretsResult.secrets()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # Declare the data source
     *   kmsSecretsDs:
     *     fn::invoke:
     *       Function: alicloud:kms:getSecrets
     *       Arguments:
     *         fetchTags: true
     *         nameRegex: name_regex
     *         tags:
     *           k-aa: v-aa
     *           k-bb: v-bb
     * outputs:
     *   firstSecretId: ${kmsSecretsDs.secrets[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSecrets.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: GetSecretsPlainArgs): GetSecretsResult =
        getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())

    /**
     * @see [getSecrets].
     * @param enableDetails Default to `false`. Set it to true can output more details.
     * @param fetchTags Whether to include the predetermined resource tag in the return value. Default to `false`.
     * @param filters The secret filter. The filter consists of one or more key-value pairs.
     * More details see API [ListSecrets](https://www.alibabacloud.com/help/en/key-management-service/latest/listsecrets).
     * @param ids A list of KMS Secret ids. The value is same as KMS secret_name.
     * @param nameRegex A regex string to filter the results by the KMS secret_name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(
        enableDetails: Boolean? = null,
        fetchTags: Boolean? = null,
        filters: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetSecretsResult {
        val argument = GetSecretsPlainArgs(
            enableDetails = enableDetails,
            fetchTags = fetchTags,
            filters = filters,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getSecretsResultToKotlin(getSecretsPlain(argument.toJava()).await())
    }

    /**
     * @see [getSecrets].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetSecretsPlainArgs].
     * @return A collection of values returned by getSecrets.
     */
    public suspend fun getSecrets(argument: suspend GetSecretsPlainArgsBuilder.() -> Unit): GetSecretsResult {
        val builder = GetSecretsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSecretsResultToKotlin(getSecretsPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can open KMS service automatically. If the service has been opened, it will return opened.
     * For information about KMS and how to use it, see [What is KMS](https://help.aliyun.com/document_detail/186020.html).
     * > **NOTE:** Available in v1.108.0+
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.kms.getService({
     *     enable: "On",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.kms.get_service(enable="On")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Kms.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := kms.GetService(ctx, &kms.GetServiceArgs{
     * 			Enable: pulumi.StringRef("On"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.kms.KmsFunctions;
     * import com.pulumi.alicloud.kms.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = KmsFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:kms:getService
     *       Arguments:
     *         enable: On
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * > **NOTE:** Setting `enable = "On"` to open the KMS service that means you have read and agreed the [KMS Terms of Service](https://help.aliyun.com/document_detail/125937.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;kms&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
