@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [NetworkRule].
 */
@PulumiTagMarker
public class NetworkRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkRuleArgs = NetworkRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkRuleArgsBuilder.() -> Unit) {
        val builder = NetworkRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkRule {
        val builtJavaResource = com.pulumi.alicloud.kms.NetworkRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkRule(builtJavaResource)
    }
}

/**
 * Provides a KMS Network Rule resource. Network rules that can be bound by Application Access Point's policies.
 * For information about KMS Network Rule and how to use it, see [What is Network Rule](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createnetworkrule).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.kms.NetworkRule("default", {
 *     description: "example-description",
 *     sourcePrivateIps: [
 *         "10.10.10.10/24",
 *         "192.168.17.13",
 *         "100.177.24.254",
 *     ],
 *     networkRuleName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.kms.NetworkRule("default",
 *     description="example-description",
 *     source_private_ips=[
 *         "10.10.10.10/24",
 *         "192.168.17.13",
 *         "100.177.24.254",
 *     ],
 *     network_rule_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Kms.NetworkRule("default", new()
 *     {
 *         Description = "example-description",
 *         SourcePrivateIps = new[]
 *         {
 *             "10.10.10.10/24",
 *             "192.168.17.13",
 *             "100.177.24.254",
 *         },
 *         NetworkRuleName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := kms.NewNetworkRule(ctx, "default", &kms.NetworkRuleArgs{
 * 			Description: pulumi.String("example-description"),
 * 			SourcePrivateIps: pulumi.StringArray{
 * 				pulumi.String("10.10.10.10/24"),
 * 				pulumi.String("192.168.17.13"),
 * 				pulumi.String("100.177.24.254"),
 * 			},
 * 			NetworkRuleName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.NetworkRule;
 * import com.pulumi.alicloud.kms.NetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new NetworkRule("default", NetworkRuleArgs.builder()
 *             .description("example-description")
 *             .sourcePrivateIps(
 *                 "10.10.10.10/24",
 *                 "192.168.17.13",
 *                 "100.177.24.254")
 *             .networkRuleName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:kms:NetworkRule
 *     properties:
 *       description: example-description
 *       sourcePrivateIps:
 *         - 10.10.10.10/24
 *         - 192.168.17.13
 *         - 100.177.24.254
 *       networkRuleName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Network Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/networkRule:NetworkRule example <id>
 * ```
 */
public class NetworkRule internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.NetworkRule,
) : KotlinCustomResource(javaResource, NetworkRuleMapper) {
    /**
     * Description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Network Rule Name.
     */
    public val networkRuleName: Output<String>
        get() = javaResource.networkRuleName().applyValue({ args0 -> args0 })

    /**
     * Allowed private network addresses.
     */
    public val sourcePrivateIps: Output<List<String>>
        get() = javaResource.sourcePrivateIps().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object NetworkRuleMapper : ResourceMapper<NetworkRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.NetworkRule::class == javaResource::class

    override fun map(javaResource: Resource): NetworkRule = NetworkRule(
        javaResource as
            com.pulumi.alicloud.kms.NetworkRule,
    )
}

/**
 * @see [NetworkRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkRule].
 */
public suspend fun networkRule(name: String, block: suspend NetworkRuleResourceBuilder.() -> Unit): NetworkRule {
    val builder = NetworkRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkRule(name: String): NetworkRule {
    val builder = NetworkRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
