@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.NetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a KMS Network Rule resource. Network rules that can be bound by Application Access Point's policies.
 * For information about KMS Network Rule and how to use it, see [What is Network Rule](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createnetworkrule).
 * > **NOTE:** Available since v1.210.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.kms.NetworkRule("default", {
 *     description: "example-description",
 *     sourcePrivateIps: [
 *         "10.10.10.10/24",
 *         "192.168.17.13",
 *         "100.177.24.254",
 *     ],
 *     networkRuleName: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.kms.NetworkRule("default",
 *     description="example-description",
 *     source_private_ips=[
 *         "10.10.10.10/24",
 *         "192.168.17.13",
 *         "100.177.24.254",
 *     ],
 *     network_rule_name=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Kms.NetworkRule("default", new()
 *     {
 *         Description = "example-description",
 *         SourcePrivateIps = new[]
 *         {
 *             "10.10.10.10/24",
 *             "192.168.17.13",
 *             "100.177.24.254",
 *         },
 *         NetworkRuleName = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := kms.NewNetworkRule(ctx, "default", &kms.NetworkRuleArgs{
 * 			Description: pulumi.String("example-description"),
 * 			SourcePrivateIps: pulumi.StringArray{
 * 				pulumi.String("10.10.10.10/24"),
 * 				pulumi.String("192.168.17.13"),
 * 				pulumi.String("100.177.24.254"),
 * 			},
 * 			NetworkRuleName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.NetworkRule;
 * import com.pulumi.alicloud.kms.NetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new NetworkRule("default", NetworkRuleArgs.builder()
 *             .description("example-description")
 *             .sourcePrivateIps(
 *                 "10.10.10.10/24",
 *                 "192.168.17.13",
 *                 "100.177.24.254")
 *             .networkRuleName(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:kms:NetworkRule
 *     properties:
 *       description: example-description
 *       sourcePrivateIps:
 *         - 10.10.10.10/24
 *         - 192.168.17.13
 *         - 100.177.24.254
 *       networkRuleName: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Network Rule can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/networkRule:NetworkRule example <id>
 * ```
 * @property description Description.
 * @property networkRuleName Network Rule Name.
 * @property sourcePrivateIps Allowed private network addresses.
 */
public data class NetworkRuleArgs(
    public val description: Output<String>? = null,
    public val networkRuleName: Output<String>? = null,
    public val sourcePrivateIps: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.NetworkRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.NetworkRuleArgs =
        com.pulumi.alicloud.kms.NetworkRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .networkRuleName(networkRuleName?.applyValue({ args0 -> args0 }))
            .sourcePrivateIps(sourcePrivateIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NetworkRuleArgs].
 */
@PulumiTagMarker
public class NetworkRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var networkRuleName: Output<String>? = null

    private var sourcePrivateIps: Output<List<String>>? = null

    /**
     * @param value Description.
     */
    @JvmName("uqdgbxinuffyhkme")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Network Rule Name.
     */
    @JvmName("mgvjxgralmwmsecv")
    public suspend fun networkRuleName(`value`: Output<String>) {
        this.networkRuleName = value
    }

    /**
     * @param value Allowed private network addresses.
     */
    @JvmName("xqrdyryvodbtyepd")
    public suspend fun sourcePrivateIps(`value`: Output<List<String>>) {
        this.sourcePrivateIps = value
    }

    @JvmName("qbuxlgwpsihvxjjj")
    public suspend fun sourcePrivateIps(vararg values: Output<String>) {
        this.sourcePrivateIps = Output.all(values.asList())
    }

    /**
     * @param values Allowed private network addresses.
     */
    @JvmName("xwxsehdwhcpmcfuq")
    public suspend fun sourcePrivateIps(values: List<Output<String>>) {
        this.sourcePrivateIps = Output.all(values)
    }

    /**
     * @param value Description.
     */
    @JvmName("wxvkntmjjmngsyyr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Network Rule Name.
     */
    @JvmName("ujfvanijhhexfqkj")
    public suspend fun networkRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkRuleName = mapped
    }

    /**
     * @param value Allowed private network addresses.
     */
    @JvmName("julfxsmdsjhxeeax")
    public suspend fun sourcePrivateIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePrivateIps = mapped
    }

    /**
     * @param values Allowed private network addresses.
     */
    @JvmName("nyfjssvjablmbsto")
    public suspend fun sourcePrivateIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourcePrivateIps = mapped
    }

    internal fun build(): NetworkRuleArgs = NetworkRuleArgs(
        description = description,
        networkRuleName = networkRuleName,
        sourcePrivateIps = sourcePrivateIps,
    )
}
