@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.PolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a KMS Policy resource. Permission policies which can be bound to the Application Access Points.
 * For information about KMS Policy and how to use it, see [What is Policy](https://www.alibabacloud.com/help/zh/key-management-service/latest/api-createpolicy).
 * > **NOTE:** Available since v1.210.0.
 * ## Import
 * KMS Policy can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/policy:Policy example <id>
 * ```
 * @property accessControlRules Network Rules in JSON struct.
 * @property description Description.
 * @property kmsInstanceId KMS instance .
 * @property permissions Allowed permissions (RBAC)Optional values:"RbacPermission/Template/CryptoServiceKeyUser" and "RbacPermission/Template/CryptoServiceSecretUser".
 * @property policyName Policy Name.
 * @property resources The resources that the permission policy allows to access.Use "key/${KeyId}" or "key/*"  to specify a key or all keys.Use "secret/${SecretName}" or "secret/*" to specify a secret or all secrets.
 * */*/
 */
public data class PolicyArgs(
    public val accessControlRules: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kmsInstanceId: Output<String>? = null,
    public val permissions: Output<List<String>>? = null,
    public val policyName: Output<String>? = null,
    public val resources: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.PolicyArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.PolicyArgs =
        com.pulumi.alicloud.kms.PolicyArgs.builder()
            .accessControlRules(accessControlRules?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsInstanceId(kmsInstanceId?.applyValue({ args0 -> args0 }))
            .permissions(permissions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .resources(resources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var accessControlRules: Output<String>? = null

    private var description: Output<String>? = null

    private var kmsInstanceId: Output<String>? = null

    private var permissions: Output<List<String>>? = null

    private var policyName: Output<String>? = null

    private var resources: Output<List<String>>? = null

    /**
     * @param value Network Rules in JSON struct.
     */
    @JvmName("xtcvvmtfuxwllxkc")
    public suspend fun accessControlRules(`value`: Output<String>) {
        this.accessControlRules = value
    }

    /**
     * @param value Description.
     */
    @JvmName("raxajwdffesftpga")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KMS instance .
     */
    @JvmName("nvbdljplfqxoumdf")
    public suspend fun kmsInstanceId(`value`: Output<String>) {
        this.kmsInstanceId = value
    }

    /**
     * @param value Allowed permissions (RBAC)Optional values:"RbacPermission/Template/CryptoServiceKeyUser" and "RbacPermission/Template/CryptoServiceSecretUser".
     */
    @JvmName("myxtvmfxjofnfbki")
    public suspend fun permissions(`value`: Output<List<String>>) {
        this.permissions = value
    }

    @JvmName("uexplcvafoecaevm")
    public suspend fun permissions(vararg values: Output<String>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values Allowed permissions (RBAC)Optional values:"RbacPermission/Template/CryptoServiceKeyUser" and "RbacPermission/Template/CryptoServiceSecretUser".
     */
    @JvmName("ygghiknoeocjkjxt")
    public suspend fun permissions(values: List<Output<String>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Policy Name.
     */
    @JvmName("vqnmdtylvnayxrty")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The resources that the permission policy allows to access.Use "key/${KeyId}" or "key/*"  to specify a key or all keys.Use "secret/${SecretName}" or "secret/*" to specify a secret or all secrets.
     * */*/
     */
    @JvmName("domseprjlmetbyhd")
    public suspend fun resources(`value`: Output<List<String>>) {
        this.resources = value
    }

    @JvmName("bxkmulkoerhqvnut")
    public suspend fun resources(vararg values: Output<String>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values The resources that the permission policy allows to access.Use "key/${KeyId}" or "key/*"  to specify a key or all keys.Use "secret/${SecretName}" or "secret/*" to specify a secret or all secrets.
     * */*/
     */
    @JvmName("ullshurppnyphkbj")
    public suspend fun resources(values: List<Output<String>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value Network Rules in JSON struct.
     */
    @JvmName("kdpdenyuwligchif")
    public suspend fun accessControlRules(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessControlRules = mapped
    }

    /**
     * @param value Description.
     */
    @JvmName("exanmkqgyesovems")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KMS instance .
     */
    @JvmName("sweyfqduttxxsrkl")
    public suspend fun kmsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsInstanceId = mapped
    }

    /**
     * @param value Allowed permissions (RBAC)Optional values:"RbacPermission/Template/CryptoServiceKeyUser" and "RbacPermission/Template/CryptoServiceSecretUser".
     */
    @JvmName("qbqfelvvyyhnuhvv")
    public suspend fun permissions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values Allowed permissions (RBAC)Optional values:"RbacPermission/Template/CryptoServiceKeyUser" and "RbacPermission/Template/CryptoServiceSecretUser".
     */
    @JvmName("ygmyadsicdqifwiu")
    public suspend fun permissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Policy Name.
     */
    @JvmName("kdivhdsvwgehtciu")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The resources that the permission policy allows to access.Use "key/${KeyId}" or "key/*"  to specify a key or all keys.Use "secret/${SecretName}" or "secret/*" to specify a secret or all secrets.
     * */*/
     */
    @JvmName("jarchsxxtbhhfbfg")
    public suspend fun resources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param values The resources that the permission policy allows to access.Use "key/${KeyId}" or "key/*"  to specify a key or all keys.Use "secret/${SecretName}" or "secret/*" to specify a secret or all secrets.
     * */*/
     */
    @JvmName("gjpnuemymhrsusuo")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        accessControlRules = accessControlRules,
        description = description,
        kmsInstanceId = kmsInstanceId,
        permissions = permissions,
        policyName = policyName,
        resources = resources,
    )
}
