@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Secret].
 */
@PulumiTagMarker
public class SecretResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretArgs = SecretArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretArgsBuilder.() -> Unit) {
        val builder = SecretArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Secret {
        val builtJavaResource = com.pulumi.alicloud.kms.Secret(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Secret(builtJavaResource)
    }
}

/**
 * Provides a KMS Secret resource.
 * For information about KMS Secret and how to use it, see [What is Secret](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createsecret).
 * > **NOTE:** Available since v1.76.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.kms.Secret("default", {
 *     secretName: name,
 *     secretData: "Secret data",
 *     versionId: "v1",
 *     forceDeleteWithoutRecovery: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.kms.Secret("default",
 *     secret_name=name,
 *     secret_data="Secret data",
 *     version_id="v1",
 *     force_delete_without_recovery=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Kms.Secret("default", new()
 *     {
 *         SecretName = name,
 *         SecretData = "Secret data",
 *         VersionId = "v1",
 *         ForceDeleteWithoutRecovery = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := kms.NewSecret(ctx, "default", &kms.SecretArgs{
 * 			SecretName:                 pulumi.String(name),
 * 			SecretData:                 pulumi.String("Secret data"),
 * 			VersionId:                  pulumi.String("v1"),
 * 			ForceDeleteWithoutRecovery: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Secret;
 * import com.pulumi.alicloud.kms.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Secret("default", SecretArgs.builder()
 *             .secretName(name)
 *             .secretData("Secret data")
 *             .versionId("v1")
 *             .forceDeleteWithoutRecovery(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:kms:Secret
 *     properties:
 *       secretName: ${name}
 *       secretData: Secret data
 *       versionId: v1
 *       forceDeleteWithoutRecovery: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Secret can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/secret:Secret example <id>
 * ```
 */
public class Secret internal constructor(
    override val javaResource: com.pulumi.alicloud.kms.Secret,
) : KotlinCustomResource(javaResource, SecretMapper) {
    /**
     * The ARN of the secret.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.224.0) The time when the secret is created.
     */
    public val createTime: Output<String>
        get() = javaResource.createTime().applyValue({ args0 -> args0 })

    /**
     * The description of the secret.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the KMS instance.
     */
    public val dkmsInstanceId: Output<String>?
        get() = javaResource.dkmsInstanceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
     */
    public val enableAutomaticRotation: Output<Boolean>?
        get() = javaResource.enableAutomaticRotation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the KMS key.
     */
    public val encryptionKeyId: Output<String>?
        get() = javaResource.encryptionKeyId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
     */
    public val extendedConfig: Output<String>?
        get() = javaResource.extendedConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
     */
    public val forceDeleteWithoutRecovery: Output<Boolean>?
        get() = javaResource.forceDeleteWithoutRecovery().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time when the secret is scheduled to be deleted.
     */
    public val plannedDeleteTime: Output<String>
        get() = javaResource.plannedDeleteTime().applyValue({ args0 -> args0 })

    /**
     * The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
     */
    public val policy: Output<String>
        get() = javaResource.policy().applyValue({ args0 -> args0 })

    /**
     * Specifies the recovery period of the secret if you do not forcibly delete it. Default value: `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
     */
    public val recoveryWindowInDays: Output<Int>?
        get() = javaResource.recoveryWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The interval for automatic rotation.
     */
    public val rotationInterval: Output<String>?
        get() = javaResource.rotationInterval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The data of the secret. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
     */
    public val secretData: Output<String>
        get() = javaResource.secretData().applyValue({ args0 -> args0 })

    /**
     * The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
     */
    public val secretDataType: Output<String>?
        get() = javaResource.secretDataType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the secret.
     */
    public val secretName: Output<String>
        get() = javaResource.secretName().applyValue({ args0 -> args0 })

    /**
     * The type of the secret. Valid values:
     * - `Generic`: Generic secret.
     * - `Rds`: ApsaraDB RDS secret.
     * - `RAMCredentials`: RAM secret.
     * - `ECS`: ECS secret.
     */
    public val secretType: Output<String>
        get() = javaResource.secretType().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The version number of the initial version.
     */
    public val versionId: Output<String>
        get() = javaResource.versionId().applyValue({ args0 -> args0 })

    /**
     * The stage label that is used to mark the new version.
     */
    public val versionStages: Output<List<String>>
        get() = javaResource.versionStages().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object SecretMapper : ResourceMapper<Secret> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.kms.Secret::class == javaResource::class

    override fun map(javaResource: Resource): Secret = Secret(
        javaResource as
            com.pulumi.alicloud.kms.Secret,
    )
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Secret].
 */
public suspend fun secret(name: String, block: suspend SecretResourceBuilder.() -> Unit): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Secret].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secret(name: String): Secret {
    val builder = SecretResourceBuilder()
    builder.name(name)
    return builder.build()
}
