@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin

import com.pulumi.alicloud.kms.SecretArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a KMS Secret resource.
 * For information about KMS Secret and how to use it, see [What is Secret](https://www.alibabacloud.com/help/en/kms/developer-reference/api-createsecret).
 * > **NOTE:** Available since v1.76.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.kms.Secret("default", {
 *     secretName: name,
 *     secretData: "Secret data",
 *     versionId: "v1",
 *     forceDeleteWithoutRecovery: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.kms.Secret("default",
 *     secret_name=name,
 *     secret_data="Secret data",
 *     version_id="v1",
 *     force_delete_without_recovery=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Kms.Secret("default", new()
 *     {
 *         SecretName = name,
 *         SecretData = "Secret data",
 *         VersionId = "v1",
 *         ForceDeleteWithoutRecovery = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := kms.NewSecret(ctx, "default", &kms.SecretArgs{
 * 			SecretName:                 pulumi.String(name),
 * 			SecretData:                 pulumi.String("Secret data"),
 * 			VersionId:                  pulumi.String("v1"),
 * 			ForceDeleteWithoutRecovery: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.kms.Secret;
 * import com.pulumi.alicloud.kms.SecretArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Secret("default", SecretArgs.builder()
 *             .secretName(name)
 *             .secretData("Secret data")
 *             .versionId("v1")
 *             .forceDeleteWithoutRecovery(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:kms:Secret
 *     properties:
 *       secretName: ${name}
 *       secretData: Secret data
 *       versionId: v1
 *       forceDeleteWithoutRecovery: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * KMS Secret can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:kms/secret:Secret example <id>
 * ```
 * @property description The description of the secret.
 * @property dkmsInstanceId The ID of the KMS instance.
 * @property enableAutomaticRotation Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
 * @property encryptionKeyId The ID of the KMS key.
 * @property extendedConfig The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
 * @property forceDeleteWithoutRecovery Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
 * @property policy The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
 * @property recoveryWindowInDays Specifies the recovery period of the secret if you do not forcibly delete it. Default value: `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
 * @property rotationInterval The interval for automatic rotation.
 * @property secretData The data of the secret. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
 * @property secretDataType The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
 * @property secretName The name of the secret.
 * @property secretType The type of the secret. Valid values:
 * - `Generic`: Generic secret.
 * - `Rds`: ApsaraDB RDS secret.
 * - `RAMCredentials`: RAM secret.
 * - `ECS`: ECS secret.
 * @property tags A mapping of tags to assign to the resource.
 * @property versionId The version number of the initial version.
 * @property versionStages The stage label that is used to mark the new version.
 */
public data class SecretArgs(
    public val description: Output<String>? = null,
    public val dkmsInstanceId: Output<String>? = null,
    public val enableAutomaticRotation: Output<Boolean>? = null,
    public val encryptionKeyId: Output<String>? = null,
    public val extendedConfig: Output<String>? = null,
    public val forceDeleteWithoutRecovery: Output<Boolean>? = null,
    public val policy: Output<String>? = null,
    public val recoveryWindowInDays: Output<Int>? = null,
    public val rotationInterval: Output<String>? = null,
    public val secretData: Output<String>? = null,
    public val secretDataType: Output<String>? = null,
    public val secretName: Output<String>? = null,
    public val secretType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val versionId: Output<String>? = null,
    public val versionStages: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.SecretArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.SecretArgs =
        com.pulumi.alicloud.kms.SecretArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .dkmsInstanceId(dkmsInstanceId?.applyValue({ args0 -> args0 }))
            .enableAutomaticRotation(enableAutomaticRotation?.applyValue({ args0 -> args0 }))
            .encryptionKeyId(encryptionKeyId?.applyValue({ args0 -> args0 }))
            .extendedConfig(extendedConfig?.applyValue({ args0 -> args0 }))
            .forceDeleteWithoutRecovery(forceDeleteWithoutRecovery?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .recoveryWindowInDays(recoveryWindowInDays?.applyValue({ args0 -> args0 }))
            .rotationInterval(rotationInterval?.applyValue({ args0 -> args0 }))
            .secretData(secretData?.applyValue({ args0 -> args0 }))
            .secretDataType(secretDataType?.applyValue({ args0 -> args0 }))
            .secretName(secretName?.applyValue({ args0 -> args0 }))
            .secretType(secretType?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionId(versionId?.applyValue({ args0 -> args0 }))
            .versionStages(versionStages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SecretArgs].
 */
@PulumiTagMarker
public class SecretArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var dkmsInstanceId: Output<String>? = null

    private var enableAutomaticRotation: Output<Boolean>? = null

    private var encryptionKeyId: Output<String>? = null

    private var extendedConfig: Output<String>? = null

    private var forceDeleteWithoutRecovery: Output<Boolean>? = null

    private var policy: Output<String>? = null

    private var recoveryWindowInDays: Output<Int>? = null

    private var rotationInterval: Output<String>? = null

    private var secretData: Output<String>? = null

    private var secretDataType: Output<String>? = null

    private var secretName: Output<String>? = null

    private var secretType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var versionId: Output<String>? = null

    private var versionStages: Output<List<String>>? = null

    /**
     * @param value The description of the secret.
     */
    @JvmName("qygdhhqccmvgwtls")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The ID of the KMS instance.
     */
    @JvmName("biixafjtyrhknpdm")
    public suspend fun dkmsInstanceId(`value`: Output<String>) {
        this.dkmsInstanceId = value
    }

    /**
     * @param value Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("fpysmewywxhvtnaa")
    public suspend fun enableAutomaticRotation(`value`: Output<Boolean>) {
        this.enableAutomaticRotation = value
    }

    /**
     * @param value The ID of the KMS key.
     */
    @JvmName("hlieedygxskvbkex")
    public suspend fun encryptionKeyId(`value`: Output<String>) {
        this.encryptionKeyId = value
    }

    /**
     * @param value The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
     */
    @JvmName("ekrplpckpbdgpiul")
    public suspend fun extendedConfig(`value`: Output<String>) {
        this.extendedConfig = value
    }

    /**
     * @param value Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("vkomkhwwarhpyaqy")
    public suspend fun forceDeleteWithoutRecovery(`value`: Output<Boolean>) {
        this.forceDeleteWithoutRecovery = value
    }

    /**
     * @param value The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
     */
    @JvmName("wncjnfvsugaeesfr")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Specifies the recovery period of the secret if you do not forcibly delete it. Default value: `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
     */
    @JvmName("spdpiqaiuirnmoor")
    public suspend fun recoveryWindowInDays(`value`: Output<Int>) {
        this.recoveryWindowInDays = value
    }

    /**
     * @param value The interval for automatic rotation.
     */
    @JvmName("janrgynbjlgsysbl")
    public suspend fun rotationInterval(`value`: Output<String>) {
        this.rotationInterval = value
    }

    /**
     * @param value The data of the secret. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
     */
    @JvmName("bvbletkxrmajhdeo")
    public suspend fun secretData(`value`: Output<String>) {
        this.secretData = value
    }

    /**
     * @param value The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
     */
    @JvmName("welngyroimhqgrpx")
    public suspend fun secretDataType(`value`: Output<String>) {
        this.secretDataType = value
    }

    /**
     * @param value The name of the secret.
     */
    @JvmName("jywworixsewmejtx")
    public suspend fun secretName(`value`: Output<String>) {
        this.secretName = value
    }

    /**
     * @param value The type of the secret. Valid values:
     * - `Generic`: Generic secret.
     * - `Rds`: ApsaraDB RDS secret.
     * - `RAMCredentials`: RAM secret.
     * - `ECS`: ECS secret.
     */
    @JvmName("ysqkcioyttjhctjm")
    public suspend fun secretType(`value`: Output<String>) {
        this.secretType = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("hbqsldrjstdiikad")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The version number of the initial version.
     */
    @JvmName("mirrfmxulkyitkst")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value The stage label that is used to mark the new version.
     */
    @JvmName("khrlvktdjxyrbxxy")
    public suspend fun versionStages(`value`: Output<List<String>>) {
        this.versionStages = value
    }

    @JvmName("lhpkylrgvtnbtbap")
    public suspend fun versionStages(vararg values: Output<String>) {
        this.versionStages = Output.all(values.asList())
    }

    /**
     * @param values The stage label that is used to mark the new version.
     */
    @JvmName("ixyjacoydxudlifb")
    public suspend fun versionStages(values: List<Output<String>>) {
        this.versionStages = Output.all(values)
    }

    /**
     * @param value The description of the secret.
     */
    @JvmName("ysmgmdrtycsiyxwl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The ID of the KMS instance.
     */
    @JvmName("efbualjvgxygeado")
    public suspend fun dkmsInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dkmsInstanceId = mapped
    }

    /**
     * @param value Specifies whether to enable automatic rotation. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("ouvkjygtthihurqr")
    public suspend fun enableAutomaticRotation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticRotation = mapped
    }

    /**
     * @param value The ID of the KMS key.
     */
    @JvmName("htluiwwcpyjqimly")
    public suspend fun encryptionKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKeyId = mapped
    }

    /**
     * @param value The extended configuration of the secret. For more information, see [How to use it](https://www.alibabacloud.com/help/en/key-management-service/latest/kms-createsecret).
     */
    @JvmName("krhntikshxskgklm")
    public suspend fun extendedConfig(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedConfig = mapped
    }

    /**
     * @param value Specifies whether to immediately delete a secret. Default value: `false`. Valid values: `true`, `false`.
     */
    @JvmName("caxjapqvmngellgh")
    public suspend fun forceDeleteWithoutRecovery(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDeleteWithoutRecovery = mapped
    }

    /**
     * @param value The content of the secret policy. The value is in the JSON format. The value can be up to 32,768 bytes in length. For more information, see [How to use it](https://www.alibabacloud.com/help/en/kms/developer-reference/api-setsecretpolicy).
     */
    @JvmName("vqukjjhyigwfblbv")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Specifies the recovery period of the secret if you do not forcibly delete it. Default value: `30`. **NOTE:**  If `force_delete_without_recovery` is set to `true`, `recovery_window_in_days` will be ignored.
     */
    @JvmName("qlurbosxjmlbisym")
    public suspend fun recoveryWindowInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryWindowInDays = mapped
    }

    /**
     * @param value The interval for automatic rotation.
     */
    @JvmName("ensgxlxwjqoygeui")
    public suspend fun rotationInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationInterval = mapped
    }

    /**
     * @param value The data of the secret. **NOTE:** From version 1.204.1, attribute `secret_data` updating diff will be ignored when `secret_type` is not Generic.
     */
    @JvmName("srxpywvwoxvjaqpe")
    public suspend fun secretData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretData = mapped
    }

    /**
     * @param value The type of the secret value. Default value: `text`. Valid values: `text`, `binary`.
     */
    @JvmName("qaifehsuaebovstm")
    public suspend fun secretDataType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretDataType = mapped
    }

    /**
     * @param value The name of the secret.
     */
    @JvmName("otbfwtardwjmlmbm")
    public suspend fun secretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value The type of the secret. Valid values:
     * - `Generic`: Generic secret.
     * - `Rds`: ApsaraDB RDS secret.
     * - `RAMCredentials`: RAM secret.
     * - `ECS`: ECS secret.
     */
    @JvmName("kxnbyrvlqgiqefcn")
    public suspend fun secretType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretType = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("voxwxmqepueqovvo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ofjpjkibcrnatahp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The version number of the initial version.
     */
    @JvmName("uqtxoowskxrhibcy")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    /**
     * @param value The stage label that is used to mark the new version.
     */
    @JvmName("qgbuybeuxluhtyet")
    public suspend fun versionStages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionStages = mapped
    }

    /**
     * @param values The stage label that is used to mark the new version.
     */
    @JvmName("bapwkmmobveycung")
    public suspend fun versionStages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.versionStages = mapped
    }

    internal fun build(): SecretArgs = SecretArgs(
        description = description,
        dkmsInstanceId = dkmsInstanceId,
        enableAutomaticRotation = enableAutomaticRotation,
        encryptionKeyId = encryptionKeyId,
        extendedConfig = extendedConfig,
        forceDeleteWithoutRecovery = forceDeleteWithoutRecovery,
        policy = policy,
        recoveryWindowInDays = recoveryWindowInDays,
        rotationInterval = rotationInterval,
        secretData = secretData,
        secretDataType = secretDataType,
        secretName = secretName,
        secretType = secretType,
        tags = tags,
        versionId = versionId,
        versionStages = versionStages,
    )
}
