@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.GetCiphertextPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCiphertext.
 * @property encryptionContext The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
 * @property keyId The globally unique ID of the CMK.
 * @property plaintext The plaintext to be encrypted which must be encoded in Base64.
 */
public data class GetCiphertextPlainArgs(
    public val encryptionContext: Map<String, String>? = null,
    public val keyId: String,
    public val plaintext: String,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.GetCiphertextPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.GetCiphertextPlainArgs =
        com.pulumi.alicloud.kms.inputs.GetCiphertextPlainArgs.builder()
            .encryptionContext(
                encryptionContext?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .keyId(keyId.let({ args0 -> args0 }))
            .plaintext(plaintext.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCiphertextPlainArgs].
 */
@PulumiTagMarker
public class GetCiphertextPlainArgsBuilder internal constructor() {
    private var encryptionContext: Map<String, String>? = null

    private var keyId: String? = null

    private var plaintext: String? = null

    /**
     * @param value The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("gqkoxwglaccnawee")
    public suspend fun encryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encryptionContext = mapped
    }

    /**
     * @param values The Encryption context. If you specify this parameter here, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("sulxwnhrepvcdshb")
    public fun encryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.encryptionContext = mapped
    }

    /**
     * @param value The globally unique ID of the CMK.
     */
    @JvmName("dkrxnymmodjnyrgd")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyId = mapped
    }

    /**
     * @param value The plaintext to be encrypted which must be encoded in Base64.
     */
    @JvmName("dbjktfuxqxuhixgg")
    public suspend fun plaintext(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.plaintext = mapped
    }

    internal fun build(): GetCiphertextPlainArgs = GetCiphertextPlainArgs(
        encryptionContext = encryptionContext,
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        plaintext = plaintext ?: throw PulumiNullFieldException("plaintext"),
    )
}
