@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.GetKeyVersionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKeyVersions.
 * @property ids A list of KMS KeyVersion IDs.
 * @property keyId The id of kms key.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetKeyVersionsPlainArgs(
    public val ids: List<String>? = null,
    public val keyId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.GetKeyVersionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.GetKeyVersionsPlainArgs =
        com.pulumi.alicloud.kms.inputs.GetKeyVersionsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyId(keyId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeyVersionsPlainArgs].
 */
@PulumiTagMarker
public class GetKeyVersionsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyId: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of KMS KeyVersion IDs.
     */
    @JvmName("rpcnhteqlchwahcu")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of KMS KeyVersion IDs.
     */
    @JvmName("fsipatdloqisvkvq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The id of kms key.
     */
    @JvmName("muwsxdkhdkxkfcbg")
    public suspend fun keyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gwwckyvhhpkobtet")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetKeyVersionsPlainArgs = GetKeyVersionsPlainArgs(
        ids = ids,
        keyId = keyId ?: throw PulumiNullFieldException("keyId"),
        outputFile = outputFile,
    )
}
