@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.GetKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getKeys.
 * @property descriptionRegex A regex string to filter the results by the KMS key description.
 * @property enableDetails
 * @property filters The CMK filter. The filter consists of one or more key-value pairs.
 * You can specify a maximum of 10 key-value pairs. More details see API [ListKeys](https://www.alibabacloud.com/help/en/key-management-service/latest/listkeys).
 * @property ids A list of KMS key IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
 */
public data class GetKeysPlainArgs(
    public val descriptionRegex: String? = null,
    public val enableDetails: Boolean? = null,
    public val filters: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.GetKeysPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.GetKeysPlainArgs =
        com.pulumi.alicloud.kms.inputs.GetKeysPlainArgs.builder()
            .descriptionRegex(descriptionRegex?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetKeysPlainArgs].
 */
@PulumiTagMarker
public class GetKeysPlainArgsBuilder internal constructor() {
    private var descriptionRegex: String? = null

    private var enableDetails: Boolean? = null

    private var filters: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A regex string to filter the results by the KMS key description.
     */
    @JvmName("ojshrypvomtopgbf")
    public suspend fun descriptionRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.descriptionRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("ubcnnbhpprnjetve")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The CMK filter. The filter consists of one or more key-value pairs.
     * You can specify a maximum of 10 key-value pairs. More details see API [ListKeys](https://www.alibabacloud.com/help/en/key-management-service/latest/listkeys).
     */
    @JvmName("dywpiqmpphbrcvgj")
    public suspend fun filters(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of KMS key IDs.
     */
    @JvmName("rifptapgxmbltkmt")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of KMS key IDs.
     */
    @JvmName("woaebmlfmclbwkxd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fcrmmxdtdhjrhvlb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Filter the results by status of the KMS keys. Valid values: `Enabled`, `Disabled`, `PendingDeletion`.
     */
    @JvmName("cswkkvcxixbrduml")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetKeysPlainArgs = GetKeysPlainArgs(
        descriptionRegex = descriptionRegex,
        enableDetails = enableDetails,
        filters = filters,
        ids = ids,
        outputFile = outputFile,
        status = status,
    )
}
