@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.kms.kotlin.inputs

import com.pulumi.alicloud.kms.inputs.GetPlaintextPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPlaintext.
 * @property ciphertextBlob The ciphertext to be decrypted.
 * @property encryptionContext (Optional) The Encryption context. If you specify this parameter in the Encrypt or GenerateDataKey API operation, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
 */
public data class GetPlaintextPlainArgs(
    public val ciphertextBlob: String,
    public val encryptionContext: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.kms.inputs.GetPlaintextPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.kms.inputs.GetPlaintextPlainArgs =
        com.pulumi.alicloud.kms.inputs.GetPlaintextPlainArgs.builder()
            .ciphertextBlob(ciphertextBlob.let({ args0 -> args0 }))
            .encryptionContext(
                encryptionContext?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GetPlaintextPlainArgs].
 */
@PulumiTagMarker
public class GetPlaintextPlainArgsBuilder internal constructor() {
    private var ciphertextBlob: String? = null

    private var encryptionContext: Map<String, String>? = null

    /**
     * @param value The ciphertext to be decrypted.
     */
    @JvmName("sjelpijgflrditxb")
    public suspend fun ciphertextBlob(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ciphertextBlob = mapped
    }

    /**
     * @param value (Optional) The Encryption context. If you specify this parameter in the Encrypt or GenerateDataKey API operation, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("kkbbippqcfdaheij")
    public suspend fun encryptionContext(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encryptionContext = mapped
    }

    /**
     * @param values (Optional) The Encryption context. If you specify this parameter in the Encrypt or GenerateDataKey API operation, it is also required when you call the Decrypt API operation. For more information, see [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm).
     */
    @JvmName("gxhsjhsuasbtvnoh")
    public fun encryptionContext(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.encryptionContext = mapped
    }

    internal fun build(): GetPlaintextPlainArgs = GetPlaintextPlainArgs(
        ciphertextBlob = ciphertextBlob ?: throw PulumiNullFieldException("ciphertextBlob"),
        encryptionContext = encryptionContext,
    )
}
